/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.clock;

import com.cognos.cm.util.clock.HighResClock;
import com.cognos.cm.util.clock.HighResClockFactory;
import java.util.LinkedList;

public class CMClock {
    protected static LinkedList<HighResClock> clocks = new LinkedList();

    private static HighResClock createClock() {
        HighResClockFactory factory = new HighResClockFactory();
        return factory.newClockInstance();
    }

    public static long getTicks() {
        return clocks.get(0).getTicks();
    }

    public static long getTicksPerSec() {
        return clocks.get(0).getTicksPerSec();
    }

    public static double convertTicksToMillis(long ticks) {
        return (double)ticks / ((double)CMClock.getTicksPerSec() / 1000.0);
    }

    public static double convertAndRoundTicksToMillis(long ticks) {
        return Math.round(CMClock.convertTicksToMillis(ticks));
    }

    public static void push(HighResClock clock) {
        clocks.add(0, clock);
    }

    public static HighResClock pop() {
        return clocks.remove(0);
    }

    static {
        CMClock.push(CMClock.createClock());
    }
}

