/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.csv;

import com.cognos.cm.util.csv.CSVRecord;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;

public class CSVReader
implements Iterable<CSVRecord>,
Iterator<CSVRecord>,
Closeable {
    private Reader in;
    private char[] buf;
    private int pos;
    private int limit;
    private CSVRecord record;
    private StringBuilder builder;
    private boolean eol;
    private int recordSize = -1;
    ArrayList<String> columns = new ArrayList();
    LinkedHashMap<String, Integer> headers;

    public CSVReader(Reader r) throws IOException {
        this.record = new CSVRecord(this);
        this.in = r;
        this.buf = new char[4096];
        this.pos = 0;
        this.limit = 0;
        this.builder = new StringBuilder();
    }

    public void headers(String ... names) {
        this.headers = new LinkedHashMap(names.length);
        int i = 0;
        for (String name : names) {
            this.headers.put(name, i++);
        }
    }

    public List<String> readHeaders() throws IOException {
        this.readRow();
        this.headers(this.columns.toArray(new String[this.columns.size()]));
        return this.getHeaders();
    }

    public List<String> getHeaders() {
        if (this.headers == null) {
            return null;
        }
        return new ArrayList<String>(this.headers.keySet());
    }

    public CSVReader(InputStream is) throws IOException {
        this(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    private boolean fillBuf() throws IOException {
        this.pos = 0;
        this.limit = this.in.read(this.buf);
        return this.limit != -1;
    }

    private void readRow() throws IOException {
        this.columns.clear();
        this.eol = false;
        while (!this.eol) {
            String field = this.readField();
            this.columns.add(field);
        }
        if (this.recordSize == -1) {
            this.recordSize = this.columns.size();
        } else if (this.columns.size() != this.recordSize) {
            StringBuilder b = new StringBuilder();
            b.append("Inconsistent record sizes, current: ").append(this.columns.size()).append(", previous: ").append(this.recordSize);
            throw new IOException(b.toString());
        }
        if (this.pos == this.limit) {
            this.fillBuf();
        }
    }

    private String readField() throws IOException {
        this.builder.setLength(0);
        if (this.pos == this.limit && !this.fillBuf()) {
            this.eol = true;
            return "";
        }
        if (this.buf[this.pos] == '\"') {
            this.readQuoted();
        } else {
            this.readUnquoted();
        }
        String result = this.builder.toString();
        boolean crlf = false;
        while (true) {
            if (this.pos < this.limit) {
                if (crlf) {
                    if (this.buf[this.pos] == '\n') {
                        this.eol = true;
                        ++this.pos;
                        return result;
                    }
                    CSVReader.reportUnexpectedChar(this.buf[this.pos]);
                }
                if (this.buf[this.pos] == ',') {
                    ++this.pos;
                    return result;
                }
                if (this.buf[this.pos] == '\r') {
                    crlf = true;
                } else {
                    if (this.buf[this.pos] == '\n') {
                        this.eol = true;
                        ++this.pos;
                        return result;
                    }
                    CSVReader.reportUnexpectedChar(this.buf[this.pos]);
                }
                ++this.pos;
                continue;
            }
            this.fillBuf();
            if (this.limit == -1) break;
        }
        this.eol = true;
        return result;
    }

    private static void reportUnexpectedChar(char ch) throws IOException {
        StringBuilder b = new StringBuilder();
        b.append("Unexpected character: '");
        String sch = ch < ' ' || ch > '~' ? String.format("\\u%04x", ch) : String.valueOf(ch);
        b.append(sch).append('\'');
        throw new IOException(b.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readQuoted() throws IOException {
        ++this.pos;
        boolean quote = false;
        do {
            int start = this.pos;
            while (this.pos < this.limit) {
                if (quote) {
                    if (this.buf[this.pos] != '\"') return;
                    quote = false;
                    start = this.pos;
                } else if (this.buf[this.pos] == '\"') {
                    quote = true;
                    this.append(start);
                }
                ++this.pos;
            }
            if (!quote) {
                this.append(start);
            }
            this.fillBuf();
        } while (this.limit != -1);
        if (quote) return;
        throw new IOException("unexpected end of file");
    }

    private void readUnquoted() throws IOException {
        do {
            int start = this.pos;
            while (this.pos < this.limit) {
                if (this.buf[this.pos] == ',' || this.buf[this.pos] == '\r' || this.buf[this.pos] == '\n') {
                    this.append(start);
                    return;
                }
                ++this.pos;
            }
            if (this.pos != start) {
                this.builder.append(this.buf, start, this.pos - start);
            }
            this.fillBuf();
        } while (this.limit != -1);
    }

    private void append(int start) {
        if (this.pos != start) {
            this.builder.append(this.buf, start, this.pos - start);
        }
    }

    @Override
    public Iterator<CSVRecord> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.limit != -1;
    }

    @Override
    public CSVRecord next() {
        if (this.limit == -1) {
            throw new NoSuchElementException();
        }
        try {
            this.readRow();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.record;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

