/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.csv;

import com.cognos.cm.util.csv.CSVReader;
import java.util.Iterator;

public class CSVRecord
implements Iterable<String> {
    private CSVReader reader;

    CSVRecord(CSVReader rdr) {
        this.reader = rdr;
    }

    public String get(int i) {
        return this.reader.columns.get(i);
    }

    public String get(String name) {
        Integer n = this.reader.headers.get(name);
        if (n == null) {
            throw new IllegalArgumentException("Invalid coulmn name");
        }
        return this.reader.columns.get(n);
    }

    public String get(Enum<?> name) {
        return this.reader.columns.get(name.ordinal());
    }

    public int getInt(int i) {
        return Integer.parseInt(this.get(i));
    }

    public int getInt(String name) {
        return Integer.parseInt(this.get(name));
    }

    public int getInt(Enum<?> name) {
        return Integer.parseInt(this.get(name));
    }

    public boolean getBoolean(int i) {
        return "true".equals(this.get(i));
    }

    public boolean getBoolean(String name) {
        return "true".equals(this.get(name));
    }

    public boolean getBoolean(Enum<?> name) {
        return "true".equals(this.get(name));
    }

    public double getDouble(int i) {
        return Double.parseDouble(this.get(i));
    }

    public double getDouble(String name) {
        return Double.parseDouble(this.get(name));
    }

    public double getDouble(Enum<?> name) {
        return Double.parseDouble(this.get(name));
    }

    public int size() {
        return this.reader.columns.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.reader.columns.iterator();
    }
}

