/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.csv;

import com.cognos.cm.util.csv.CSVUtils;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Formatter;

public class CSVWriter
implements Closeable,
Flushable {
    private Appendable out;
    private StringBuilder record;
    private String fieldSeparator;
    private String lineSeparator;
    private IOException error = null;
    private StringBuilder fmtBuf;
    private Formatter formatter;

    public CSVWriter(OutputStream out) throws IOException {
        this(new OutputStreamWriter(out, "utf-8"));
    }

    public CSVWriter(Appendable out) {
        this.out = out;
        this.record = new StringBuilder();
        this.fmtBuf = new StringBuilder();
        this.formatter = new Formatter(this.fmtBuf);
        this.fieldSeparator = "";
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void setLineSeparator(String sep) {
        this.lineSeparator = sep;
    }

    public IOException getError() {
        return this.error;
    }

    public void clearError() {
        this.error = null;
    }

    public CSVWriter write(String value) {
        return this.writeRaw(CSVUtils.encodeData(value));
    }

    public CSVWriter write(boolean value) {
        return this.writeRaw(String.valueOf(value));
    }

    public CSVWriter write(int value) {
        return this.writeRaw(String.valueOf(value));
    }

    public CSVWriter write(long value) {
        return this.writeRaw(String.valueOf(value));
    }

    public CSVWriter write(float value) {
        return this.writeRaw(String.valueOf(value));
    }

    public CSVWriter write(double value) {
        return this.writeRaw(String.valueOf(value));
    }

    public CSVWriter writeRaw(String value) {
        this.record.append(this.fieldSeparator).append(value);
        this.fieldSeparator = ",";
        return this;
    }

    public CSVWriter writeFormatted(String format, Object value) {
        this.formatter.format(format, value);
        this.write(this.fmtBuf.toString());
        this.fmtBuf.setLength(0);
        return this;
    }

    public CSVWriter writeFormattedRaw(String fmt, Object value) {
        this.formatter.format(fmt, value);
        this.record.append(this.fieldSeparator).append((CharSequence)this.fmtBuf);
        this.fmtBuf.setLength(0);
        this.fieldSeparator = ",";
        return this;
    }

    public CSVWriter endRecord() {
        block2: {
            this.record.append(this.lineSeparator);
            try {
                this.out.append(this.record);
            }
            catch (IOException e) {
                if (this.error != null) break block2;
                this.error = e;
            }
        }
        this.record.setLength(0);
        this.fieldSeparator = "";
        return this;
    }

    @Override
    public void close() {
        block3: {
            if (this.out instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.out)).close();
                }
                catch (IOException e) {
                    if (this.error != null) break block3;
                    this.error = e;
                }
            }
        }
    }

    @Override
    public void flush() {
        block3: {
            if (this.out instanceof Flushable) {
                try {
                    ((Flushable)((Object)this.out)).flush();
                }
                catch (IOException e) {
                    if (this.error != null) break block3;
                    this.error = e;
                }
            }
        }
    }
}

