/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.factory;

import com.cognos.cm.util.factory.CMFactoryLocator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMFactory {
    static final String LOGGER_NAME = "com.cognos.cm.util.factory.CMFactory";
    private List<CMFactoryLocator> locators = new ArrayList<CMFactoryLocator>();

    public CMFactory(String fallback) {
        this.locators.add(new CMFactoryFallbackLocator(fallback));
    }

    public void addLocator(CMFactoryLocator locator) {
        if (null != locator) {
            this.locators.add(this.locators.size() - 1, locator);
        }
    }

    public void insertLocator(CMFactoryLocator locator, int index) throws IndexOutOfBoundsException {
        if (this.locators.size() == index) {
            throw new IndexOutOfBoundsException("A CMFactoryLocator cannot be added to the last position. This position is reserved for the fall-back locator.");
        }
        this.locators.add(index, locator);
    }

    public int getLocatorCount() {
        return this.locators.size();
    }

    String determineClass() {
        String className = null;
        for (CMFactoryLocator locator : this.locators) {
            className = locator.getLocatedValue();
            if (null == className) continue;
            Logger.getLogger(LOGGER_NAME).log(Level.FINE, "The CMFactory object determined that the interface implementation '" + className + "' should be loaded using locator '" + locator.toString() + "'.");
            break;
        }
        return className;
    }

    public Object newInstance() {
        return this.newInstance(null, null, null);
    }

    public FactoryMethod getFactoryMethod(String methodName, Class<?>[] types) {
        String className = this.determineClass();
        try {
            Class<?> klass = Class.forName(className);
            Method method = klass.getMethod(methodName, types);
            return new StaticFactoryMethod(method);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object newInstance(String factoryMethod, Class<?>[] types, Object[] params) {
        String className = this.determineClass();
        try {
            Class<?> klass = Class.forName(className);
            Object result = null == factoryMethod ? this.newInstanceWithConstructor(types, klass, params) : this.newInstanceWithMethod(factoryMethod, klass, types, params);
            return result;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(LOGGER_NAME).log(Level.SEVERE, "The class name '" + className + "' determined by the CMFactory object could not be found by the class loader.", ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(LOGGER_NAME).log(Level.SEVERE, "The class name '" + className + "' determined by the CMFactory object cannot be instantiated because it is an abstract class.", ex);
        }
        return null;
    }

    private void logNoSuchMethodException(String methodType, String className, Class<?>[] types, Exception ex) {
        Logger.getLogger(LOGGER_NAME).log(Level.SEVERE, "The class name '" + className + "' determined by the CMFactory object does not have a " + methodType + " matching to provided parameter types (" + CMFactory.getClassNames(types) + ").", ex);
    }

    private void logIllegalAccessException(String methodType, String className, String modifiers, Exception ex) {
        Logger.getLogger(LOGGER_NAME).log(Level.SEVERE, "The class name '" + className + "' determined by the CMFactory object cannot be instantiated because the specified constructor is not accessible (" + modifiers + ") to the CMFactory class.", ex);
    }

    private void logSecurityException(String methodType, String className, Exception ex) {
        Logger.getLogger(LOGGER_NAME).log(Level.SEVERE, "The SecurityManager prevented the application from accessing the specified " + methodType + " of the class '" + className + "' determined by the CMFactory object.", ex);
    }

    private void logIllegalArgumentException(String methodType, String className, Object[] params, Class<?>[] types, Exception ex) {
        Logger.getLogger(LOGGER_NAME).log(Level.SEVERE, "The arguments provided (" + CMFactory.getTypesOfObjects(params) + ") are not compatible with the set of formal parameters (" + CMFactory.getClassNames(types) + ") for the specified " + methodType + " in the class '" + className + "' determined by the CMFactory object.", ex);
    }

    private void logInvocationTargetException(String methodType, String className, Class<?>[] types, String targetExcepction, Exception ex) {
        Logger.getLogger(LOGGER_NAME).log(Level.SEVERE, "The specified " + methodType + " with the formal parameters (" + CMFactory.getClassNames(types) + "), in the class '" + className + "' determined by the CMFactory object, threw a " + targetExcepction + " when it was invoked.", ex);
    }

    private Object newInstanceWithConstructor(Class<?>[] types, Class<?> klass, Object[] params) throws InstantiationException {
        Constructor<?> constructor = null;
        String methodType = "constructor";
        try {
            constructor = klass.getConstructor(types);
            return constructor.newInstance(params);
        }
        catch (NoSuchMethodException ex) {
            this.logNoSuchMethodException("constructor", klass.getName(), types, ex);
        }
        catch (IllegalAccessException ex) {
            this.logIllegalAccessException("constructor", klass.getName(), Modifier.toString(constructor.getModifiers()), ex);
        }
        catch (SecurityException ex) {
            this.logSecurityException("constructor", klass.getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            this.logIllegalArgumentException("constructor", klass.getName(), params, types, ex);
        }
        catch (InvocationTargetException ex) {
            this.logInvocationTargetException("constructor", klass.getName(), types, ex.getTargetException().getClass().getName(), ex);
        }
        return null;
    }

    private Object newInstanceWithMethod(String factoryMethod, Class<?> klass, Class<?>[] types, Object[] params) throws IllegalArgumentException {
        Method method = null;
        String methodType = "method";
        try {
            method = klass.getMethod(factoryMethod, types);
            return method.invoke(null, params);
        }
        catch (NoSuchMethodException ex) {
            this.logNoSuchMethodException("method", klass.getName(), types, ex);
        }
        catch (IllegalAccessException ex) {
            this.logIllegalAccessException("method", klass.getName(), Modifier.toString(method.getModifiers()), ex);
        }
        catch (SecurityException ex) {
            this.logSecurityException("method", klass.getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            this.logIllegalArgumentException("method", klass.getName(), params, types, ex);
        }
        catch (InvocationTargetException ex) {
            this.logInvocationTargetException("method", klass.getName(), types, ex.getTargetException().getClass().getName(), ex);
        }
        return null;
    }

    private static String getClassNames(Class<?>[] types) {
        StringBuffer buffer = new StringBuffer(32 * types.length);
        String sep = "";
        for (int i = 0; i < types.length; ++i) {
            buffer.append(sep);
            buffer.append(types[i].getName());
            sep = ", ";
        }
        return buffer.toString();
    }

    private static String getTypesOfObjects(Object[] objects) {
        StringBuffer buffer = new StringBuffer(32 * objects.length);
        String sep = "";
        for (int i = 0; i < objects.length; ++i) {
            buffer.append(sep);
            buffer.append(objects[i].getClass().getName());
            sep = ", ";
        }
        return buffer.toString();
    }

    private static class CMFactoryFallbackLocator
    implements CMFactoryLocator {
        private String fallback;

        public CMFactoryFallbackLocator(String fallback) {
            this.fallback = fallback;
        }

        @Override
        public String getLocatedValue() {
            return this.fallback;
        }

        public String toString() {
            return "Fall back locator (default: " + this.fallback + ")";
        }
    }

    private static class StaticFactoryMethod
    implements FactoryMethod {
        private Method method;

        public StaticFactoryMethod(Method method) {
            this.method = method;
        }

        @Override
        public Object newInstance(Object arg1) {
            try {
                return this.method.invoke(null, arg1);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
        }
    }

    public static interface FactoryMethod {
        public Object newInstance(Object var1);
    }
}

