/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.factory;

import com.cognos.cm.util.factory.CMFactoryLocator;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMFactoryContextClassLoaderLocator
implements CMFactoryLocator {
    private String resourceName;
    private String property;

    public CMFactoryContextClassLoaderLocator(String resourceName, String property) {
        this.resourceName = resourceName;
        this.property = property;
    }

    @Override
    public String getLocatedValue() {
        ClassLoader contextClassLoader = this.getContextClassLoaderFromCurrentThread();
        if (null != contextClassLoader) {
            return this.getLocatedValueWithClassLoader(contextClassLoader);
        }
        return null;
    }

    private ClassLoader getContextClassLoaderFromCurrentThread() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException ex) {
            Logger.getLogger("com.cognos.cm.util.factory.CMFactory").log(Level.WARNING, "A security manager prevented the application from getting the context class loader for the current thread.", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLocatedValueWithClassLoader(ClassLoader contextClassLoader) {
        InputStream is = contextClassLoader.getResourceAsStream(this.resourceName);
        if (null != is) {
            Properties props = new Properties();
            try {
                props.load(is);
                String string = props.getProperty(this.property);
                return string;
            }
            catch (IOException ex) {
                Logger.getLogger("com.cognos.cm.util.factory.CMFactory").log(Level.WARNING, "An exception occurred while reading the properties file '" + this.resourceName + "' from the class path.", ex);
            }
            finally {
                CMStreamUtils.quietClose(is);
            }
        }
        return null;
    }

    public String toString() {
        return "Context class loader locator (resource name: " + this.resourceName + ", property name: " + this.property + ")";
    }
}

