/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.factory;

import com.cognos.cm.util.factory.CMFactoryLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMFactoryPropFileLocator
implements CMFactoryLocator {
    private File file;
    private String property;

    public CMFactoryPropFileLocator(File file, String property) {
        this.file = file;
        this.property = property;
    }

    @Override
    public String getLocatedValue() {
        String s = null;
        try {
            FileInputStream is = new FileInputStream(this.file);
            Properties props = new Properties();
            try {
                props.load(is);
            }
            catch (IOException ex) {
                Logger.getLogger("com.cognos.cm.util.factory.CMFactory").log(Level.WARNING, "An exception occurred while reading the properties file '" + this.file.getAbsolutePath() + "'.", ex);
            }
            s = props.getProperty(this.property);
        }
        catch (FileNotFoundException is) {
        }
        catch (SecurityException ex) {
            Logger.getLogger("com.cognos.cm.util.factory.CMFactory").log(Level.WARNING, "A security manager prevented the application from reading the properties file '" + this.file.getAbsolutePath() + "'.", ex);
        }
        return s;
    }

    public String toString() {
        return "Properties file locator (file: " + this.file.getAbsolutePath() + ", property: " + this.property + ")";
    }
}

