/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.factory;

import com.cognos.cm.util.factory.CMFactoryLocator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMFactoryResourceBundleLocator
implements CMFactoryLocator {
    private String resourceName;
    private String property;
    private Locale locale;

    public CMFactoryResourceBundleLocator(String resourceName, String property, Locale locale) {
        this.resourceName = resourceName;
        this.property = property;
        this.locale = locale;
    }

    @Override
    public String getLocatedValue() {
        String s = null;
        try {
            ResourceBundle is = ResourceBundle.getBundle(this.resourceName, this.locale, Thread.currentThread().getContextClassLoader());
            if (null != is) {
                s = is.getString(this.property);
            }
        }
        catch (SecurityException ex) {
            Logger.getLogger("com.cognos.cm.util.factory.CMFactory").log(Level.WARNING, "A security manager prevented the application from getting the context class loader for the current thread.", ex);
        }
        catch (MissingResourceException ex) {
            s = null;
        }
        return s;
    }

    public String toString() {
        return "Resource bundle locator (resource name: " + this.resourceName + ", property name: " + this.property + ")";
    }
}

