/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.service;

import com.cognos.cm.util.service.CMRunningMode;
import com.cognos.cm.util.service.CMStatusParameter;
import com.cognos.cm.util.service.CMStatusParameterName;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ServiceStateHelper {
    private static final String CM_SERVLET_FQN = "com.cognos.cm.server.CMServlet";
    private static boolean cmClassLoadAttempted = false;
    private static Class<?> cmClazz;
    private final Class<?> cmServletClazz;
    private final Map<CMStatusParameterName, Field> parameterMap;

    ServiceStateHelper(Class<?> cmServletClazz) {
        this.cmServletClazz = cmServletClazz;
        this.parameterMap = new HashMap<CMStatusParameterName, Field>(CMStatusParameterName.values().length);
        this.prepareParameterMap();
    }

    private void prepareParameterMap() {
        if (this.cmServletClazz != null) {
            Field[] fields;
            for (Field field : fields = this.cmServletClazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(CMStatusParameter.class)) continue;
                CMStatusParameter annotation = field.getAnnotation(CMStatusParameter.class);
                this.parameterMap.put(annotation.name(), field);
            }
        }
    }

    public CMRunningMode getCMRunningMode() {
        Integer runningState = (Integer)this.getStatusParameterValue(CMStatusParameterName.RUNNING_MODE);
        if (runningState == null || runningState > CMRunningMode.STAND_BY_MODE.ordinal()) {
            return CMRunningMode.NOT_PRESENT;
        }
        return CMRunningMode.values()[runningState];
    }

    public boolean isCMComingUp() {
        return this.getBooleanParameter(CMStatusParameterName.IS_COMING_UP);
    }

    public boolean isCMShuttingDown() {
        return this.getBooleanParameter(CMStatusParameterName.IS_SHUTTINGDOWN);
    }

    public boolean isCMSuspended() {
        return this.getBooleanParameter(CMStatusParameterName.IS_SUSPENDED);
    }

    public boolean hasCMShutdown() {
        return this.getBooleanParameter(CMStatusParameterName.HAS_SHUTDOWN);
    }

    private boolean getBooleanParameter(CMStatusParameterName parameterName) {
        Boolean value = (Boolean)this.getStatusParameterValue(parameterName);
        if (value == null) {
            return false;
        }
        return value;
    }

    private Object getStatusParameterValue(CMStatusParameterName parameterName) {
        Object parameterValue = null;
        Field field = this.parameterMap.get((Object)parameterName);
        if (field != null) {
            try {
                parameterValue = field.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parameterValue;
    }

    Class<?> getCmServletClazz() {
        return this.cmServletClazz;
    }

    private static void loadCMServletClass() {
        if (!cmClassLoadAttempted) {
            try {
                cmClazz = ServiceStateHelper.class.getClassLoader().loadClass(CM_SERVLET_FQN);
            }
            catch (Exception exception) {
                // empty catch block
            }
            cmClassLoadAttempted = true;
        }
    }

    public static ServiceStateHelper getInstance() {
        ServiceStateHelper.loadCMServletClass();
        return new ServiceStateHelper(cmClazz);
    }
}

