/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.version;

import java.util.ArrayList;

public class Version {
    private String versionNumber;
    private String extendedVersionNumber;
    private String title;

    private Version(String implementationTitle, String implementationVersion) {
        this.title = implementationTitle;
        this.parseImplementationVersion(implementationVersion);
    }

    private void parseImplementationVersion(String version) {
        if (null == version) {
            return;
        }
        String buildLabel = version;
        int pos = buildLabel.indexOf(" (");
        if (-1 != pos) {
            buildLabel = version.substring(0, pos);
            this.extendedVersionNumber = version.substring(pos + 2, version.length() - 1);
        }
        this.versionNumber = buildLabel;
    }

    public String getImplementationTitle() {
        return this.title;
    }

    public String getExtendedVersion() {
        return this.extendedVersionNumber;
    }

    public String getVersion() {
        return this.versionNumber;
    }

    public static Version getVersion(Class<?> klass) {
        Package pkg = klass.getPackage();
        return new Version(pkg.getImplementationTitle(), pkg.getImplementationVersion());
    }

    public static void main(String[] args) {
        Class<Object>[] classes = 0 == args.length ? new Class[]{Version.class} : Version.parseClassNames(args);
        for (Class<?> clazz : classes) {
            Version.displayVersionInfo(clazz);
        }
    }

    private static Class<?>[] parseClassNames(String[] classNames) {
        ArrayList list = new ArrayList();
        for (String className : classNames) {
            try {
                list.add(Class.forName(className));
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Class '" + className + "' could not be found.");
            }
        }
        return list.toArray(new Class[list.size()]);
    }

    private static void displayVersionInfo(Class<?> klass) {
        Version version = Version.getVersion(klass);
        System.out.println("Version Info for package: " + klass.getPackage().getName());
        System.out.println("\tVersion: " + version.getVersion());
        System.out.println("\tExtended version: " + version.getExtendedVersion());
        System.out.println("\tImplementation title: " + version.getImplementationTitle());
        System.out.println();
    }
}

