/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.collections;

import com.cognos.cmutils.collections.Filter;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilterIterator<E>
implements Iterator<E> {
    private Iterator<E> it;
    private Filter<E> filter;
    private E next;
    private E current;

    public FilterIterator(Iterator<E> it, Filter<E> filter) {
        this.it = it;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.it.hasNext()) {
            this.next = this.it.next();
            if (!this.filter.accept(this.next)) continue;
            return true;
        }
        this.next = null;
        return false;
    }

    @Override
    public E next() {
        if (this.next == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        this.next = null;
        return this.current;
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.current = null;
        this.it.remove();
    }
}

