/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.collections;

import com.cognos.cmutils.values.MathUtils;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class IntSet {
    int[] hashes;
    int[] data;
    int free = -1;
    int data_size = 0;
    int size = 0;
    int threshold = 0;
    int mask;
    boolean hasMinusOne;

    public IntSet() {
        this(16);
    }

    public IntSet(int capacity) {
        if (capacity < 8) {
            capacity = 8;
        }
        this.init(capacity);
    }

    private void init(int capacity) {
        int hashSize = MathUtils.pow2(capacity * 4 / 3);
        this.mask = hashSize - 1;
        this.threshold = hashSize * 3 / 4;
        this.hashes = new int[hashSize];
        Arrays.fill(this.hashes, -1);
        this.data = new int[capacity * 2];
        Arrays.fill(this.data, -1);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean contains(int value) {
        if (value == -1) {
            return this.hasMinusOne;
        }
        int pos = this.hashes[value & this.mask];
        while (pos >= 0) {
            if (this.data[pos] == value) {
                return true;
            }
            pos = this.data[pos + 1];
        }
        return false;
    }

    public boolean remove(int value) {
        if (value == -1) {
            if (this.hasMinusOne) {
                this.hasMinusOne = false;
                --this.size;
                return true;
            }
            return false;
        }
        int hash = value & this.mask;
        int pos = this.hashes[hash];
        int prev = -1;
        while (pos >= 0 && this.data[pos] != value) {
            prev = pos;
            pos = this.data[pos + 1];
        }
        if (pos < 0) {
            return false;
        }
        if (prev == -1) {
            this.hashes[hash] = this.data[pos + 1];
        } else {
            this.data[prev + 1] = this.data[pos + 1];
        }
        this.data[pos + 1] = this.free;
        this.free = pos;
        this.data[pos] = -1;
        --this.size;
        return true;
    }

    public boolean add(int value) {
        int pos;
        if (this.contains(value)) {
            return false;
        }
        if (value == -1) {
            this.hasMinusOne = true;
            ++this.size;
            return true;
        }
        if (this.size + 1 >= this.threshold) {
            this.rehash();
        }
        int hash = value & this.mask;
        if (this.free < 0) {
            if (this.data_size >= this.data.length) {
                this.expandData();
            }
            pos = this.data_size;
            this.data_size += 2;
        } else {
            pos = this.free;
            this.free = this.data[this.free + 1];
        }
        this.data[pos] = value;
        this.data[pos + 1] = this.hashes[hash];
        this.hashes[hash] = pos;
        ++this.size;
        return true;
    }

    private void expandData() {
        int[] tmp = new int[this.data.length * 2];
        System.arraycopy(this.data, 0, tmp, 0, this.data.length);
        Arrays.fill(tmp, this.data.length, tmp.length, -1);
        this.data = tmp;
    }

    private void rehash() {
        int[] old_data = this.data;
        this.free = -1;
        this.size = this.hasMinusOne ? 1 : 0;
        this.threshold *= 2;
        this.data_size = 0;
        this.mask = (this.hashes.length << 1) - 1;
        this.hashes = new int[this.hashes.length << 1];
        Arrays.fill(this.hashes, -1);
        this.data = new int[old_data.length];
        Arrays.fill(this.data, -1);
        for (int i = 0; i < old_data.length; i += 2) {
            if (old_data[i] == -1) continue;
            this.add(old_data[i]);
        }
    }

    public void clear() {
        this.size = 0;
        this.free = -1;
        this.data_size = 0;
        this.hasMinusOne = false;
        Arrays.fill(this.data, -1);
        Arrays.fill(this.hashes, -1);
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public class Iterator {
        private int pos = -2;
        private int next = -2;

        private Iterator() {
            if (IntSet.this.hasMinusOne) {
                this.pos = -1;
            }
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.pos == -1) {
                this.pos = this.next;
                return -1;
            }
            this.pos = this.next;
            return IntSet.this.data[this.pos];
        }

        public boolean hasNext() {
            if (this.pos != this.next) {
                return true;
            }
            for (int i = this.next + 2; i < IntSet.this.data_size; i += 2) {
                if (IntSet.this.data[i] == -1) continue;
                this.next = i;
                return true;
            }
            return false;
        }

        public void remove() {
            if (this.pos == -2) {
                if (IntSet.this.hasMinusOne) {
                    IntSet.this.remove(-1);
                    return;
                }
            } else if (this.pos != -1 && this.pos < IntSet.this.data_size && IntSet.this.data[this.pos] != -1) {
                IntSet.this.remove(IntSet.this.data[this.pos]);
                return;
            }
            throw new IllegalStateException();
        }
    }
}

