/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.collections;

import com.cognos.cmutils.collections.Filter;
import com.cognos.cmutils.collections.LinkedArraysQueue;
import com.cognos.cmutils.collections.TreeNavigator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LevelorderTreeIterator<N>
implements Iterator<N>,
Iterable<N> {
    private TreeNavigator<N> tree;
    private Filter<N> filter;
    private LinkedArraysQueue<N> queue = new LinkedArraysQueue();
    private N current = null;
    private int trimSize = 0;

    public LevelorderTreeIterator(TreeNavigator<N> tree) {
        this(tree, null, null);
    }

    public LevelorderTreeIterator(TreeNavigator<N> tree, N root) {
        this(tree, root, null);
    }

    public LevelorderTreeIterator(TreeNavigator<N> tree, Filter<N> filter) {
        this(tree, null, filter);
    }

    public LevelorderTreeIterator(TreeNavigator<N> tree, N root, Filter<N> filter) {
        this.tree = tree;
        if (root == null) {
            root = tree.getRoot();
        }
        this.filter = this.makeFilter(filter);
        if (root != null && this.filter.accept(root)) {
            this.queue.offer(root);
        }
    }

    @Override
    public Iterator<N> iterator() {
        return this;
    }

    private Filter<N> makeFilter(Filter<N> f) {
        if (f != null) {
            return f;
        }
        return new Filter<N>(){

            @Override
            public boolean accept(N e) {
                return true;
            }
        };
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public N next() {
        if (this.queue.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.current = this.queue.poll();
        this.trimSize = this.queue.size();
        N e = this.tree.getChild(this.current);
        while (e != null) {
            if (this.filter.accept(e)) {
                this.queue.offer(e);
            }
            e = this.tree.getSibling(e);
        }
        return this.current;
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        this.tree.remove(this.current);
        this.queue.setSize(this.trimSize);
        this.current = null;
    }
}

