/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.collections;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class LinkedArraysQueue<E>
extends AbstractQueue<E> {
    private final int chunkSize;
    private int offset;
    private int limit;
    private LinkedList<E[]> chunks = new LinkedList();

    public LinkedArraysQueue() {
        this(256);
    }

    public LinkedArraysQueue(int chunkSize) {
        this.chunkSize = chunkSize;
        this.chunks.add(this.newChunk());
    }

    private E[] newChunk() {
        return new Object[this.chunkSize];
    }

    @Override
    public boolean isEmpty() {
        return this.chunks.size() == 1 && this.limit == this.offset;
    }

    @Override
    public int size() {
        return (this.chunks.size() - 1) * this.chunkSize - this.offset + this.limit;
    }

    @Override
    public boolean offer(E v) {
        if (this.limit == this.chunkSize) {
            this.chunks.add(this.newChunk());
            this.limit = 0;
        }
        E[] chunk = this.chunks.getLast();
        chunk[this.limit] = v;
        ++this.limit;
        return true;
    }

    @Override
    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        E[] chunk = this.chunks.getFirst();
        E result = chunk[this.offset];
        ++this.offset;
        if (this.offset == this.chunkSize) {
            if (this.chunks.size() > 1) {
                this.chunks.removeFirst();
            } else {
                this.limit = 0;
            }
            this.offset = 0;
        }
        if (this.isEmpty()) {
            this.limit = 0;
            this.offset = 0;
        }
        return result;
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        E[] chunk = this.chunks.getFirst();
        return chunk[this.offset];
    }

    public void setSize(int size) {
        int qsize = this.size();
        if (qsize <= size) {
            return;
        }
        if (size == 0) {
            this.clear();
            return;
        }
        for (size = qsize - size; size > this.limit; size -= this.limit) {
            this.chunks.removeLast();
            this.limit = this.chunkSize;
        }
        this.limit -= size;
        if (this.chunks.size() == 1) {
            if (this.limit == this.offset) {
                this.offset = 0;
                this.limit = 0;
            }
        } else if (this.limit == 0) {
            this.chunks.removeLast();
            this.limit = this.chunkSize;
        }
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        E[] chunk = this.chunks.getFirst();
        this.chunks.clear();
        this.chunks.add(chunk);
        this.limit = 0;
        this.offset = 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new QueueIterator();
    }

    private class QueueIterator
    implements Iterator<E> {
        private Iterator<E[]> chunksIterator;
        private E[] currentChunk;
        private int pos;

        private QueueIterator() {
            this.chunksIterator = LinkedArraysQueue.this.chunks.iterator();
            this.pos = LinkedArraysQueue.this.offset;
            if (this.chunksIterator.hasNext()) {
                this.currentChunk = this.chunksIterator.next();
                if (!this.chunksIterator.hasNext() && this.pos == LinkedArraysQueue.this.limit) {
                    this.currentChunk = null;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentChunk != null;
        }

        @Override
        public E next() {
            if (this.currentChunk == null) {
                throw new NoSuchElementException();
            }
            Object result = this.currentChunk[this.pos];
            ++this.pos;
            if (this.chunksIterator.hasNext()) {
                if (this.pos == LinkedArraysQueue.this.chunkSize) {
                    this.pos = 0;
                    this.currentChunk = this.chunksIterator.next();
                }
            } else if (this.pos == LinkedArraysQueue.this.limit) {
                this.currentChunk = null;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

