/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.collections;

import com.cognos.cmutils.collections.Filter;
import com.cognos.cmutils.collections.SubTreeNavigator;
import com.cognos.cmutils.collections.TreeNavigator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PostorderTreeIterator<N>
implements Iterator<N>,
Iterable<N> {
    private final TreeNavigator<N> tree;
    private N next;
    private N current;
    private Filter<N> filter;

    public PostorderTreeIterator(TreeNavigator<N> tree) {
        this(tree, null, null);
    }

    public PostorderTreeIterator(TreeNavigator<N> tree, N root) {
        this(tree, root, null);
    }

    public PostorderTreeIterator(TreeNavigator<N> tree, Filter<N> filter) {
        this(tree, null, filter);
    }

    public PostorderTreeIterator(TreeNavigator<N> tree, N root, Filter<N> filter) {
        if (root != null) {
            this.tree = new SubTreeNavigator<N>(tree, root);
        } else {
            this.tree = tree;
            root = tree.getRoot();
        }
        this.filter = filter;
        if (root != null) {
            if (filter != null) {
                if (filter.accept(root)) {
                    this.next = this.diveFiltered(root);
                }
            } else {
                this.next = this.dive(root);
            }
        }
    }

    @Override
    public Iterator<N> iterator() {
        return this;
    }

    private N diveFiltered(N entry) {
        N child = this.tree.getChild(entry);
        while (child != null) {
            if (this.filter.accept(child)) {
                entry = child;
                child = this.tree.getChild(child);
                continue;
            }
            child = this.tree.getSibling(child);
        }
        return entry;
    }

    private void advanceFiltered() {
        N node = this.tree.getSibling(this.next);
        while (node != null) {
            if (this.filter.accept(node)) {
                this.next = this.diveFiltered(node);
                return;
            }
            node = this.tree.getSibling(node);
        }
        this.next = this.tree.getParent(this.next);
    }

    private N dive(N entry) {
        N child;
        while ((child = this.tree.getChild(entry)) != null) {
            entry = child;
        }
        return entry;
    }

    private void advance() {
        N node = this.tree.getSibling(this.next);
        this.next = node != null ? this.dive(node) : this.tree.getParent(this.next);
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public N next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        if (this.filter != null) {
            this.advanceFiltered();
        } else {
            this.advance();
        }
        return this.current;
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException("no current entry");
        }
        this.tree.remove(this.current);
        this.current = null;
    }
}

