/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.collections;

import com.cognos.cmutils.collections.Filter;
import com.cognos.cmutils.collections.SubTreeNavigator;
import com.cognos.cmutils.collections.TreeNavigator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PreorderTreeIterator<N>
implements Iterator<N>,
Iterable<N> {
    private final TreeNavigator<N> tree;
    private N next;
    private N current;
    private final Filter<N> filter;

    public PreorderTreeIterator(TreeNavigator<N> tree) {
        this(tree, null, null);
    }

    public PreorderTreeIterator(TreeNavigator<N> tree, N root) {
        this(tree, root, null);
    }

    public PreorderTreeIterator(TreeNavigator<N> tree, Filter<N> filter) {
        this(tree, null, filter);
    }

    public PreorderTreeIterator(TreeNavigator<N> tree, N root, Filter<N> filter) {
        this.filter = filter;
        if (root != null) {
            this.tree = new SubTreeNavigator<N>(tree, root);
        } else {
            this.tree = tree;
            root = tree.getRoot();
        }
        this.next = root;
        if (this.next != null && filter != null && !filter.accept(this.next)) {
            this.next = null;
        }
    }

    @Override
    public Iterator<N> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public N next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        if (this.filter != null) {
            this.advanceFiltered(true);
        } else {
            this.advance(true);
        }
        return this.current;
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException("no current entry");
        }
        if (this.next != null && this.tree.getParent(this.next) == this.current) {
            this.next = this.current;
            if (this.filter != null) {
                this.advanceFiltered(false);
            } else {
                this.advance(false);
            }
        }
        this.tree.remove(this.current);
        this.current = null;
    }

    private void advance(boolean visitChild) {
        N node;
        if (visitChild && (node = this.tree.getChild(this.next)) != null) {
            this.next = node;
        } else {
            node = this.tree.getSibling(this.next);
            if (node != null) {
                this.next = node;
            } else {
                this.next = this.tree.getParent(this.next);
                while (this.next != null) {
                    node = this.tree.getSibling(this.next);
                    if (node != null) {
                        this.next = node;
                        break;
                    }
                    this.next = this.tree.getParent(this.next);
                }
            }
        }
    }

    private void advanceFiltered(boolean visitChild) {
        if (visitChild && this.findSiblingOrSelf(this.tree.getChild(this.next))) {
            return;
        }
        if (this.findSiblingOrSelf(this.tree.getSibling(this.next))) {
            return;
        }
        this.next = this.tree.getParent(this.next);
        while (this.next != null) {
            if (this.findSiblingOrSelf(this.tree.getSibling(this.next))) {
                return;
            }
            this.next = this.tree.getParent(this.next);
        }
    }

    private boolean findSiblingOrSelf(N node) {
        while (node != null) {
            if (this.filter.accept(node)) {
                this.next = node;
                return true;
            }
            node = this.tree.getSibling(node);
        }
        return false;
    }
}

