/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.collections;

import com.cognos.cmutils.collections.Filter;
import com.cognos.cmutils.collections.LevelorderTreeIterator;
import com.cognos.cmutils.collections.PostorderTreeIterator;
import com.cognos.cmutils.collections.PreorderTreeIterator;
import com.cognos.cmutils.collections.TreeNavigator;

public enum TraverseOrder {
    preorder,
    postorder,
    levelorder;


    public <E> Iterable<E> createIterator(TreeNavigator<E> nav, E root, Filter<E> filter) {
        switch (this) {
            case preorder: {
                return new PreorderTreeIterator<E>(nav, root, filter);
            }
            case postorder: {
                return new PostorderTreeIterator<E>(nav, root, filter);
            }
            case levelorder: {
                return new LevelorderTreeIterator<E>(nav, root, filter);
            }
        }
        throw new RuntimeException();
    }

    public <E> Iterable<E> createIterator(TreeNavigator<E> nav, Filter<E> filter) {
        return this.createIterator(nav, null, filter);
    }

    public <E> Iterable<E> createIterator(TreeNavigator<E> nav) {
        return this.createIterator(nav, null, null);
    }

    public <E> Iterable<E> createIterator(TreeNavigator<E> nav, E root) {
        return this.createIterator(nav, root, null);
    }
}

