/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.config;

import java.util.HashMap;

public class ConfigurableClassProperties {
    private static HashMap<Class<?>, ValueOfHelper<?>> valueOfHelpers = new HashMap(16);

    private static <T> T getProperty(Class<?> clazz, String propName, Class<T> type, T defaultValue) {
        Object propValue = defaultValue;
        String propKey = clazz.getName() + "." + propName;
        String propValueStr = System.getProperty(propKey);
        if (propValueStr != null) {
            ValueOfHelper<?> valueOfHelper = valueOfHelpers.get(type);
            propValue = valueOfHelper.valueOf(propValueStr);
        }
        return propValue;
    }

    public static String getString(Class<?> clazz, String propName, String defaultValue) {
        return ConfigurableClassProperties.getProperty(clazz, propName, String.class, defaultValue);
    }

    public static int getInteger(Class<?> clazz, String propName, int defaultValue) {
        return ConfigurableClassProperties.getProperty(clazz, propName, Integer.class, defaultValue);
    }

    public static boolean getBoolean(Class<?> clazz, String propName, boolean defaultValue) {
        return ConfigurableClassProperties.getProperty(clazz, propName, Boolean.class, defaultValue);
    }

    public static double getDouble(Class<?> clazz, String propName, double defaultValue) {
        return ConfigurableClassProperties.getProperty(clazz, propName, Double.class, defaultValue);
    }

    static {
        valueOfHelpers.put(String.class, new ValueOfHelper<String>(){

            @Override
            public String valueOf(String s) {
                return s;
            }
        });
        valueOfHelpers.put(Boolean.class, new ValueOfHelper<Boolean>(){

            @Override
            public Boolean valueOf(String s) {
                return Boolean.valueOf(s);
            }
        });
        valueOfHelpers.put(Integer.class, new ValueOfHelper<Integer>(){

            @Override
            public Integer valueOf(String s) {
                return Integer.valueOf(s);
            }
        });
        valueOfHelpers.put(Double.class, new ValueOfHelper<Double>(){

            @Override
            public Double valueOf(String s) {
                return Double.valueOf(s);
            }
        });
    }

    private static interface ValueOfHelper<T> {
        public T valueOf(String var1);
    }
}

