/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.date;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeParser {
    private static final int MINIMUM_DATETIME_LENGTH = 19;
    private static final int MILLISECOND_START_INDEX = 19;
    private static final TimeZone GMT_ZERO = TimeZone.getTimeZone("GMT-0");
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int millisecond;
    private int position = 0;
    private char[] sequence;
    private Calendar working;

    public DateTimeParser(char[] sequence) {
        this.sequence = sequence;
        this.working = Calendar.getInstance(GMT_ZERO);
    }

    public static Date parse(String source) {
        return new DateTimeParser(source.toCharArray()).parse();
    }

    public Date parse() {
        if (this.sequence.length < 19) {
            this.throwTheException();
        }
        this.parseDate();
        this.parseMillis();
        this.validateDateTimeValues();
        this.working.clear();
        this.working.set(this.year, this.month, this.day, this.hour, this.minute, this.second);
        this.working.set(14, this.millisecond);
        int timezoneOffsetMilliseconds = this.getTimeZoneMillisecondOffset();
        this.working.add(14, timezoneOffsetMilliseconds);
        return this.working.getTime();
    }

    private void parseDate() {
        this.year = this.parseInt(this.sequence, 0, 4);
        this.assertEquals('-', this.sequence[4]);
        this.month = this.parseInt(this.sequence, 5, 7);
        --this.month;
        this.assertEquals('-', this.sequence[7]);
        this.day = this.parseInt(this.sequence, 8, 10);
        this.assertEquals('T', this.sequence[10]);
        this.hour = this.parseInt(this.sequence, 11, 13);
        this.assertEquals(':', this.sequence[13]);
        this.minute = this.parseInt(this.sequence, 14, 16);
        this.assertEquals(':', this.sequence[16]);
        this.second = this.parseInt(this.sequence, 17, 19);
    }

    private void parseMillis() {
        int length;
        this.position = 19;
        if (this.sequence.length == this.position) {
            this.position = this.sequence.length;
            return;
        }
        if (this.sequence[this.position] != '.') {
            return;
        }
        int start = ++this.position;
        while (this.position < this.sequence.length && this.sequence[this.position] <= '9' && this.sequence[this.position] >= '0') {
            ++this.position;
        }
        if (start == this.position) {
            this.throwTheException();
        }
        if ((length = this.position - start) > 3) {
            length = 3;
        }
        this.millisecond = this.parseInt(this.sequence, start, start + length);
        if (length == 1) {
            this.millisecond *= 100;
        } else if (length == 2) {
            this.millisecond *= 10;
        }
    }

    private int getTimeZoneMillisecondOffset() {
        if (this.position == this.sequence.length) {
            return 0;
        }
        char timeZone = this.sequence[this.position];
        ++this.position;
        if (timeZone == 'Z') {
            if (this.position != this.sequence.length) {
                this.throwTheException();
            }
            return 0;
        }
        if (timeZone != '-' && timeZone != '+') {
            this.throwTheException();
        }
        if (this.sequence.length != this.position + 5) {
            this.throwTheException();
        }
        int hours = this.parseInt(this.sequence, this.position, this.position + 2);
        this.assertEquals(':', this.sequence[this.position + 2]);
        int minutes = this.parseInt(this.sequence, this.position + 3, this.position + 5);
        this.validateTimeZoneValues(hours, minutes);
        int offset = DateTimeParser.computeMilliseconds(hours, minutes);
        if (timeZone == '+') {
            offset = -offset;
        }
        return offset;
    }

    private void throwTheException() {
        throw new NumberFormatException("Invalid dateTime:" + new String(this.sequence));
    }

    private void validateTimeZoneValues(int hours, int minutes) {
        if (hours < 0 || hours > 14 || minutes < 0 || minutes > 59 || hours == 14 && minutes != 0) {
            this.throwTheException();
        }
    }

    private void validateDateTimeValues() {
        boolean valid = true;
        if (this.hour > 24 || this.minute > 59 || this.second > 59) {
            valid = false;
        } else if (this.hour == 24 && (this.minute != 0 || this.second != 0 || this.millisecond != 0)) {
            valid = false;
        }
        if (!valid) {
            this.throwTheException();
        }
    }

    private void assertEquals(char expected, char actual) {
        if (expected != actual) {
            this.throwTheException();
        }
    }

    private static int computeMilliseconds(int hours, int minutes) {
        int offset = (hours * 60 + minutes) * 60 * 1000;
        return offset;
    }

    protected int parseInt(char[] chars, int start, int end) {
        int total = 0;
        for (int i = start; i < end; ++i) {
            total = total * 10 + this.getIntVal(chars[i]);
        }
        return total;
    }

    protected int getIntVal(char character) {
        int value = character - 48;
        if (value < 0 || value > 9) {
            this.throwTheException();
        }
        return value;
    }
}

