/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.date;

import com.cognos.cmutils.date.DateTimeParser;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    protected static boolean localTimeZoneUsesDST_ = false;
    protected static int tzDSTSavings_ = 0;
    protected static TimeZone stdTimeZone_;
    protected static TimeZone dstTimeZone_;
    protected static TimeZone localTimeZone_;
    protected static final TimeZone utcTimeZone;
    protected static final TimeZone gmtTimeZone;
    protected static TimeZone defaultTimeZone;
    private static SimpleDateFormat zulu;

    public static TimeZone getUTCTimeZone() {
        return (TimeZone)utcTimeZone.clone();
    }

    public static TimeZone getDefaultTimeZone() {
        return (TimeZone)defaultTimeZone.clone();
    }

    protected static void initializeTimeZoneInfo(TimeZone defaultTimeZone) {
        localTimeZone_ = defaultTimeZone;
        if (localTimeZone_.useDaylightTime() && localTimeZone_.getRawOffset() < 0) {
            localTimeZoneUsesDST_ = true;
            tzDSTSavings_ = localTimeZone_.getDSTSavings();
            String STUTCStr = DateUtils.getUTCOffsetTimeZoneID(localTimeZone_.getRawOffset());
            stdTimeZone_ = TimeZone.getTimeZone(STUTCStr);
            String DSTUTCStr = DateUtils.getUTCOffsetTimeZoneID(localTimeZone_.getRawOffset() + tzDSTSavings_);
            dstTimeZone_ = TimeZone.getTimeZone(DSTUTCStr);
        }
    }

    public static String getIsoDate(Calendar calendar) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(calendar.get(1));
        buffer.append("-");
        buffer.append(DateUtils.twoDigit(calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(DateUtils.twoDigit(calendar.get(5)));
        buffer.append("T");
        buffer.append(DateUtils.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(DateUtils.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(DateUtils.twoDigit(calendar.get(13)));
        buffer.append(".");
        buffer.append(DateUtils.threeDigit(calendar.get(14)));
        buffer.append("Z");
        return buffer.toString();
    }

    public static long getUTCTime() {
        return DateUtils.getUTCTime(new Date(System.currentTimeMillis()));
    }

    public static long getUTCTime(Date date) {
        Calendar gmtWithLocalTimeCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        gmtWithLocalTimeCalendar.setTimeInMillis(date.getTime());
        Calendar utcCalendar = DateUtils.getUTCCalendar(gmtWithLocalTimeCalendar);
        long utcTime = utcCalendar.getTimeInMillis();
        return utcTime;
    }

    private static Calendar getUTCCalendar(Calendar gmtWithLocalTimeCalendar) {
        Calendar utcCalendar = Calendar.getInstance(defaultTimeZone);
        utcCalendar.set(1, gmtWithLocalTimeCalendar.get(1));
        utcCalendar.set(2, gmtWithLocalTimeCalendar.get(2));
        utcCalendar.set(5, gmtWithLocalTimeCalendar.get(5));
        utcCalendar.set(11, gmtWithLocalTimeCalendar.get(11));
        utcCalendar.set(12, gmtWithLocalTimeCalendar.get(12));
        utcCalendar.set(13, gmtWithLocalTimeCalendar.get(13));
        utcCalendar.set(14, gmtWithLocalTimeCalendar.get(14));
        return utcCalendar;
    }

    public static Calendar getGMTCalendar() {
        return Calendar.getInstance(gmtTimeZone);
    }

    public static Calendar getDSTNeutralCalendar() {
        if (localTimeZoneUsesDST_) {
            if (localTimeZone_.inDaylightTime(new Date())) {
                return Calendar.getInstance(dstTimeZone_);
            }
            return Calendar.getInstance(stdTimeZone_);
        }
        return Calendar.getInstance();
    }

    public static Date parse(String source) {
        return DateTimeParser.parse(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String normailizeTime(String source) {
        String ret;
        String baseDate = "1970-00-00T";
        String dateTime = baseDate + source;
        Date date = DateUtils.parse(dateTime);
        SimpleDateFormat simpleDateFormat = zulu;
        synchronized (simpleDateFormat) {
            ret = zulu.format(date).substring(11);
        }
        return ret;
    }

    private static String getUTCOffsetTimeZoneID(int offset) {
        StringBuffer result = new StringBuffer("GMT");
        if (offset == 0) {
            return result.toString();
        }
        if (offset < 0) {
            offset *= -1;
            result.append("-");
        } else {
            result.append("+");
        }
        int hours = offset / 3600000;
        result.append(DateUtils.twoDigit(hours));
        int minutes = offset % 3600000 / 60000;
        result.append(":");
        result.append(DateUtils.twoDigit(minutes));
        return result.toString();
    }

    private static String twoDigit(int i) {
        if (i >= 0 && i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    private static String threeDigit(int i) {
        if (i >= 0 && i < 10) {
            return "00" + String.valueOf(i);
        }
        if (i < 100) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    public static void setDefaultTimeZone(String ID) {
        defaultTimeZone = TimeZone.getTimeZone(ID);
    }

    static {
        utcTimeZone = TimeZone.getTimeZone("GMT-0");
        gmtTimeZone = TimeZone.getTimeZone("GMT");
        defaultTimeZone = TimeZone.getDefault();
        zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        zulu.setTimeZone((TimeZone)gmtTimeZone.clone());
        DateUtils.initializeTimeZoneInfo(defaultTimeZone);
    }
}

