/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.date;

import com.cognos.cmutils.date.DateUtils;
import java.util.Calendar;
import java.util.Date;

public class Duration {
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    private static final int DAY = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int SECOND = 5;
    private String duration_;
    private int[] offsets_;

    public Duration(String duration) {
        this.duration_ = duration;
        this.offsets_ = this.calculateOffset(this.duration_);
    }

    private int[] calculateOffset(String duration) {
        int[] offset = new int[6];
        boolean inTimePart = false;
        char[] datePartDelims = new char[]{'Y', 'M', 'D', 'T'};
        char[] timePartDelims = new char[]{'H', 'M', 'S'};
        int lastDateDelim = -1;
        int lastTimeDelim = -1;
        if (duration.charAt(0) != 'P') {
            throw new NumberFormatException(duration);
        }
        int charIdx = 1;
        int strLength = duration.length();
        while (charIdx != strLength) {
            int idx;
            char c;
            int value = 0;
            while (charIdx != strLength && (c = duration.charAt(charIdx)) >= '0' && c <= '9') {
                value = value * 10 + (c - 48);
                ++charIdx;
            }
            if (charIdx == strLength) {
                throw new NumberFormatException(duration);
            }
            char delim = duration.charAt(charIdx++);
            if (!inTimePart) {
                idx = 0;
                for (idx = lastDateDelim + 1; idx != datePartDelims.length && datePartDelims[idx] != delim; ++idx) {
                }
                if (idx == datePartDelims.length) {
                    throw new NumberFormatException(duration);
                }
                lastDateDelim = idx;
                inTimePart = delim == 'T';
                if (inTimePart) continue;
                offset[lastDateDelim] = value;
                continue;
            }
            idx = 0;
            for (idx = lastTimeDelim + 1; idx != timePartDelims.length && timePartDelims[idx] != delim; ++idx) {
            }
            if (idx == timePartDelims.length) {
                throw new NumberFormatException(duration);
            }
            lastTimeDelim = idx;
            offset[3 + lastTimeDelim] = value;
        }
        return offset;
    }

    public Date addTo(Date date) {
        Calendar calendar = Calendar.getInstance(DateUtils.getDefaultTimeZone());
        calendar.setTime(date);
        calendar = this.addTo(calendar);
        return calendar.getTime();
    }

    public Calendar addTo(Calendar calendar) {
        return this.addTo(calendar, this.offsets_);
    }

    private Calendar addTo(Calendar calendar, int[] offset) {
        int[] start = new int[]{calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13)};
        int[] end = new int[6];
        int temp = start[1] + offset[1] + 1;
        int carry = Duration.fQuotient(temp, 1, 13);
        end[1] = Duration.modulo(temp, 1, 13);
        end[0] = start[0] + offset[0] + carry;
        temp = start[5] + offset[5];
        carry = Duration.fQuotient(temp, 60);
        end[5] = Duration.modulo(temp, 60);
        temp = start[4] + offset[4] + carry;
        carry = Duration.fQuotient(temp, 60);
        end[4] = Duration.modulo(temp, 60);
        temp = start[3] + offset[3] + carry;
        carry = Duration.fQuotient(temp, 24);
        end[3] = Duration.modulo(temp, 24);
        int maxDayInMonth = Duration.maxDayInMonth(end[1], end[0]);
        temp = start[2] > maxDayInMonth ? maxDayInMonth : start[2];
        end[2] = temp + offset[2] + carry;
        while (true) {
            if (end[2] < 1) {
                end[2] = end[2] + Duration.maxDayInMonth(end[1] - 1, end[0]);
                carry = -1;
            } else {
                if (end[2] <= maxDayInMonth) break;
                end[2] = end[2] - maxDayInMonth;
                carry = 1;
            }
            temp = end[1] + carry;
            end[1] = Duration.modulo(temp, 1, 13);
            end[0] = end[0] + Duration.fQuotient(temp, 1, 13);
            maxDayInMonth = Duration.maxDayInMonth(end[1], end[0]);
        }
        calendar.set(end[0], end[1] - 1, end[2], end[3], end[4], end[5]);
        return calendar;
    }

    public Date subtractFrom(Date date) {
        Calendar calendar = Calendar.getInstance(DateUtils.getDefaultTimeZone());
        calendar.setTime(date);
        calendar = this.subtractFrom(calendar);
        return calendar.getTime();
    }

    public Calendar subtractFrom(Calendar calendar) {
        int[] offsets = this.getNegativeOffsets();
        return this.addTo(calendar, offsets);
    }

    private int[] getNegativeOffsets() {
        int[] offsets = new int[this.offsets_.length];
        for (int i = 0; i < this.offsets_.length; ++i) {
            offsets[i] = -this.offsets_[i];
        }
        return offsets;
    }

    private static int fQuotient(int a, int b) {
        return (int)Math.floor((double)a / (double)b);
    }

    private static int fQuotient(int a, int low, int high) {
        return Duration.fQuotient(a - low, high - low);
    }

    private static int modulo(int a, int low, int high) {
        return Duration.modulo(a - low, high - low) + low;
    }

    private static int modulo(int a, int b) {
        return a - Duration.fQuotient(a, b) * b;
    }

    private static int maxDayInMonth(int month, int year) {
        int m = Duration.modulo(month, 1, 13);
        int y = year + Duration.fQuotient(month, 1, 13);
        int maxDay = 0;
        switch (m) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                maxDay = 31;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                maxDay = 30;
                break;
            }
            case 2: {
                maxDay = y % 4 == 0 && y % 100 != 0 || y % 400 == 0 ? 29 : 28;
            }
        }
        return maxDay;
    }
}

