/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.hash;

import com.cognos.cmutils.hash.HashProvider;
import com.cognos.cmutils.values.CMHexFormatter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class AbstractHashProvider
implements HashProvider {
    private MessageDigest digest;

    public AbstractHashProvider(String algorithm) {
        try {
            this.digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String hash(String message) {
        byte[] bytes = null;
        bytes = this.digestMessage(message);
        return new String(CMHexFormatter.translate(bytes));
    }

    private synchronized byte[] digestMessage(String message) {
        this.digest.reset();
        this.digest.update(message.getBytes());
        return this.digest.digest();
    }
}

