/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.hash;

import com.cognos.cmutils.hash.ClearTextHashProvider;
import com.cognos.cmutils.hash.HashCodeProvider;
import com.cognos.cmutils.hash.HashProvider;
import com.cognos.cmutils.hash.JCAMCryptoHashProvider;
import com.cognos.cmutils.hash.MD5HashProvider;
import com.cognos.cmutils.hash.SHA1HashProvider;

public enum HashProviders {
    MD5(MD5HashProvider.class),
    SHA1(SHA1HashProvider.class),
    CAMCRYPTO(JCAMCryptoHashProvider.class),
    CLEARTEXT(ClearTextHashProvider.class),
    HASHCODE(HashCodeProvider.class);

    private HashProvider instance;

    private HashProviders(Class<? extends HashProvider> clazz) {
        this.instance = this.initInstance(clazz);
    }

    private HashProvider initInstance(Class<? extends HashProvider> hashProviderClass) {
        try {
            return hashProviderClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public String hash(String message) {
        return this.instance.hash(message);
    }
}

