/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.hash;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.cmutils.hash.HashProvider;
import com.cognos.cmutils.values.CMHexFormatter;

class JCAMCryptoHashProvider
implements HashProvider {
    private CAMFactory camFactory = new CAMFactory();
    private boolean initialized = false;

    JCAMCryptoHashProvider() {
    }

    private void initialize() {
        try {
            this.camFactory.initialize("<initializeDocument><serviceID>CM</serviceID></initializeDocument>".getBytes());
        }
        catch (CAMCryptoException e) {
            throw new RuntimeException(e);
        }
        this.initialized = true;
    }

    @Override
    public String hash(String clearText) {
        this.init();
        try {
            SigningSession session = this.camFactory.createSigningSession();
            byte[] hashedResult = session.hash(clearText.getBytes());
            return CMHexFormatter.translate(hashedResult);
        }
        catch (CAMCryptoException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        CAMFactory cAMFactory = this.camFactory;
        synchronized (cAMFactory) {
            if (!this.initialized) {
                this.initialize();
            }
        }
    }
}

