/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.http;

import com.cognos.cmutils.config.ConfigurableClassProperties;
import com.cognos.cmutils.http.HttpClientFactory;
import com.cognos.cmutils.http.HttpMethodFactory;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public abstract class AbstractHttpClientFactory
implements HttpClientFactory {
    private final int maxConnectionsPerHost = this.getIntProp("maxConnectionsPerHost", 1000);
    private final int maxTotalConnections = this.getIntProp("maxTotalConnections", 2000);
    private final int connectionTimeout = this.getIntProp("connectionTimeout", 30000);
    private final int socketTimeout = this.getIntProp("socketTimeout", 60000);
    private final ConcurrentHashMap<String, HttpClient> clientMap = new ConcurrentHashMap(10);

    protected AbstractHttpClientFactory() {
    }

    protected abstract HttpClient newHttpClient(String var1, int var2, boolean var3) throws IOException;

    private int getIntProp(String propName, int defaultValue) {
        return ConfigurableClassProperties.getInteger(this.getClass(), propName, defaultValue);
    }

    @Override
    public final HttpClient getHttpClient(String host, int port, boolean secure) throws IOException {
        String protocol = secure ? "https://" : "http://";
        String key = protocol + host + ":" + port;
        HttpClient client = this.clientMap.get(key);
        if (client == null) {
            client = this.newHttpClient(host, port, secure);
            MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams mgrParams = new HttpConnectionManagerParams();
            mgrParams.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, this.maxConnectionsPerHost);
            mgrParams.setMaxTotalConnections(this.maxTotalConnections);
            mgrParams.setConnectionTimeout(this.connectionTimeout);
            manager.setParams(mgrParams);
            client.setHttpConnectionManager((HttpConnectionManager)manager);
            HttpClientParams clientParams = client.getParams();
            clientParams.setSoTimeout(this.socketTimeout);
            if (this.clientMap.putIfAbsent(key, client) != null) {
                client = this.clientMap.get(key);
            }
        }
        return client;
    }

    @Override
    public HttpClient getHttpClient(URI uri) throws IOException {
        String scheme = uri.getScheme();
        boolean secure = "https".equalsIgnoreCase(scheme);
        return this.getHttpClient(uri.getHost(), uri.getPort(), secure);
    }

    @Override
    public HttpClient getHttpClient(URL url) throws IOException {
        String protocol = url.getProtocol();
        boolean secure = "https".equalsIgnoreCase(protocol);
        return this.getHttpClient(url.getHost(), url.getPort(), secure);
    }

    @Override
    public HttpMethodFactory getHttpMethodFactory(String baseUriStr) {
        return new HttpMethodFactory(this, baseUriStr);
    }
}

