/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CMStreamUtils {
    private static Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor(CMStreamUtils.class.getName());

    private static void log(IOException ioe) {
        if (log.isDebugEnabled()) {
            log.debug(ioe.getMessage());
        }
    }

    public static void quietClose(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                CMStreamUtils.log(ioe);
            }
        }
    }

    public static void quietClose(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException ioe) {
                CMStreamUtils.log(ioe);
            }
        }
    }

    public static void quietClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException ioe) {
                CMStreamUtils.log(ioe);
            }
        }
    }

    public static void quietClose(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException ioe) {
                CMStreamUtils.log(ioe);
            }
        }
    }

    public static byte[] readInputStreamIntoByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CMStreamUtils.copyStream(in, baos);
        return baos.toByteArray();
    }

    public static long copyStream(InputStream is, OutputStream os) throws IOException {
        int numRead;
        long total = 0L;
        byte[] buffer = new byte[32768];
        while ((numRead = is.read(buffer)) > 0) {
            os.write(buffer, 0, numRead);
            total += (long)numRead;
        }
        os.flush();
        return total;
    }

    public static void copyStream(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int numRead;
        byte[] buffer = new byte[bufferSize];
        while ((numRead = is.read(buffer)) > 0) {
            os.write(buffer, 0, numRead);
        }
    }

    public static String readReaderIntoString(Reader in) throws IOException {
        int numRead;
        char[] buffer = new char[10240];
        StringBuffer results = new StringBuffer(10240);
        while ((numRead = in.read(buffer)) > 0) {
            results.append(buffer, 0, numRead);
        }
        if (results.length() == 0) {
            return null;
        }
        return results.toString();
    }
}

