/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.messages;

import com.cognos.cmutils.messages.CheckedException;
import java.util.ArrayList;
import java.util.Locale;
import org.xml.sax.SAXException;

public class ExceptionUtils {
    public static String getRootStackTrace(Throwable th) {
        Throwable cause;
        while ((cause = ExceptionUtils.getCause(th)) != null) {
            th = cause;
        }
        StringBuffer buf = new StringBuffer(th.getClass().getName());
        for (StackTraceElement se : th.getStackTrace()) {
            buf.append("\n\tat ").append(se.toString());
        }
        return buf.toString();
    }

    public static Throwable getCause(Throwable th) {
        Throwable cause = th.getCause();
        if (cause != null) {
            return cause;
        }
        if (th instanceof SAXException) {
            return ((SAXException)th).getException();
        }
        return null;
    }

    public static ArrayList<String> getAllMessages(Throwable th, Locale locale) {
        ArrayList<String> result = new ArrayList<String>();
        Throwable guard = null;
        Throwable cause = th;
        while (cause != null) {
            if (cause instanceof CheckedException) {
                guard = null;
                CheckedException ce = (CheckedException)cause;
                result.addAll(ce.message.formatAll(locale));
            } else if (guard == null) {
                guard = cause;
            }
            cause = ExceptionUtils.getCause(cause);
        }
        while (guard != null) {
            result.add(guard.toString());
            guard = ExceptionUtils.getCause(guard);
        }
        return result;
    }
}

