/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.messages;

import com.cognos.cmutils.messages.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class Message {
    protected Resource.Id id;
    protected String text;
    protected HashMap<String, String> params;
    protected Message next;
    protected Message prev;

    public Message(Resource.Id rid) {
        this.id = rid;
    }

    public Message(String txt) {
        this.text = txt;
    }

    public Message param(String name, String value) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        if (!this.params.containsKey(name)) {
            this.params.put(name, value);
        }
        return this;
    }

    public Message addDetail(Resource.Id detail) {
        return this.link(new Message(detail));
    }

    public Message addDetail(Message detail) {
        return this.link(detail);
    }

    public Message addDetail(String detail) {
        return this.link(new Message(detail));
    }

    private Message link(Message m) {
        Message p = this.getMessageTail();
        p.next = m;
        m.prev = p;
        return m;
    }

    public String format(Locale loc) {
        String msg = this.id == null ? this.text : this.id.load(loc);
        return this.insertParams(msg).toString();
    }

    public String format(Locale locale, String separator) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        Message root = this.getMessageHead();
        while (root != null) {
            String s = root.format(locale);
            if (s.length() != 0) {
                if (first) {
                    first = false;
                } else {
                    buf.append(separator);
                }
                buf.append(s);
            }
            root = root.next;
        }
        return buf.toString();
    }

    public ArrayList<String> formatAll(Locale loc) {
        ArrayList<String> result = new ArrayList<String>();
        Message root = this.getMessageHead();
        while (root != null) {
            result.add(root.format(loc));
            root = root.next;
        }
        return result;
    }

    protected Message getMessageHead() {
        Message head = this;
        while (head.prev != null) {
            head = head.prev;
        }
        return head;
    }

    protected Message getMessageTail() {
        Message tail = this;
        while (tail.next != null) {
            tail = tail.next;
        }
        return tail;
    }

    private StringBuffer insertParams(String txt) {
        StringBuffer buf = new StringBuffer(txt);
        int pos = 0;
        int start;
        while ((start = buf.indexOf("{", pos)) != -1) {
            int end = buf.indexOf("}", start + 1);
            if (end == -1) {
                throw new RuntimeException("invalid message format");
            }
            String param = buf.substring(start + 1, end);
            String value = this.getParam(param);
            buf.replace(start, end + 1, value);
            pos = end + 1;
        }
        return buf;
    }

    private String getParam(String name) {
        String value = null;
        Message m = this;
        while (m != null) {
            if (m.params != null && (value = m.params.get(name)) != null) {
                return value;
            }
            m = m.prev;
        }
        return '{' + name + "?}";
    }

    public String toString() {
        if (this.id != null) {
            return this.id.toString();
        }
        return this.text;
    }
}

