/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Resource {
    private final String fileName;

    public Resource(String filename) {
        this.fileName = filename;
    }

    public String loadString(String id, Locale locale) {
        try {
            String message;
            ResourceBundle bundle = this.getBundle(locale);
            if (bundle != null && (message = bundle.getString(id)) != null) {
                return message;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return id;
    }

    public String loadString(Id id, Locale locale) {
        try {
            String message;
            ResourceBundle bundle = this.getBundle(locale, id);
            if (bundle != null && (message = bundle.getString(id.toString())) != null) {
                return message;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return id.toString();
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(this.fileName, locale);
    }

    private ResourceBundle getBundle(Locale locale, Id id) {
        try {
            return ResourceBundle.getBundle(this.fileName, locale);
        }
        catch (MissingResourceException e) {
            String pkg = id.getClass().getPackage().getName().replace('.', '/');
            StringBuffer buf = new StringBuffer(pkg).append('/').append(this.fileName);
            try {
                return ResourceBundle.getBundle(buf.toString(), locale);
            }
            catch (MissingResourceException ee) {
                return null;
            }
        }
    }

    public static interface Id {
        public String load(Locale var1);
    }
}

