/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.messages;

import com.cognos.cmutils.messages.ExceptionUtils;
import com.cognos.cmutils.messages.ExceptionWithMessage;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import java.util.ArrayList;
import java.util.Locale;

public abstract class UncheckedException
extends RuntimeException
implements ExceptionWithMessage {
    private static final long serialVersionUID = 3863199070424417131L;
    protected Message message;

    public UncheckedException() {
        this(new Message(""));
    }

    public UncheckedException(String text) {
        this(new Message(text));
    }

    public UncheckedException(Resource.Id code) {
        this(new Message(code));
    }

    public UncheckedException(Message msg) {
        this.message = msg.getMessageHead();
    }

    public UncheckedException(Throwable cause) {
        this(new Message(""), cause);
    }

    public UncheckedException(String text, Throwable cause) {
        this(new Message(text), cause);
    }

    public UncheckedException(Resource.Id code, Throwable cause) {
        this(new Message(code), cause);
    }

    public UncheckedException(Message msg, Throwable cause) {
        super(cause);
        this.message = msg.getMessageHead();
    }

    @Override
    public Message param(String name, String value) {
        this.message.param(name, value);
        return this.message;
    }

    @Override
    public Message addDetail(Resource.Id id) {
        return this.addDetail(new Message(id));
    }

    @Override
    public Message addDetail(Message m) {
        m.addDetail(this.message);
        this.message = m.getMessageHead();
        return this.message;
    }

    @Override
    public Message addDetail(String text) {
        return this.addDetail(new Message(text));
    }

    @Override
    public String getMessage() {
        return this.message.format(Locale.getDefault(), " ");
    }

    @Override
    public ArrayList<String> getAllMessages(Locale locale) {
        return ExceptionUtils.getAllMessages(this, locale);
    }

    @Override
    public String format(Locale locale) {
        return this.message.format(locale);
    }

    @Override
    public String format(Locale locale, String separator) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String s : ExceptionUtils.getAllMessages(this, locale)) {
            if (first) {
                first = false;
            } else {
                buf.append(separator);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public Message message() {
        return this.message;
    }

    public String getRootStackTrace() {
        return ExceptionUtils.getRootStackTrace(this);
    }
}

