/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.properties;

import com.cognos.cmutils.properties.IDataEncryptionHelper;
import java.util.Base64;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Credentials {
    private static final String CREDENTIALS_XML_ENCODING = "UTF-8";
    public static final String ELEM_CREDENTIALS_PASSWORD = "password";
    public static final String ELEM_CREDENTIALS_USERNAME = "username";
    private static final String ENCRYPTED_VALUE = "encryptedValue";
    private static final String BASIC_AUTHENTICATION_SEPARATOR = ":";
    private IDataEncryptionHelper es;

    public Credentials(IDataEncryptionHelper es) {
        this.es = es;
    }

    public byte[] decryptCredentialsFromPropertyValue(String sEncodedEncryptedCredentials) throws Exception {
        Element root = DocumentHelper.parseText((String)sEncodedEncryptedCredentials).getRootElement();
        byte[] dencryptedData = null;
        Element encryptedValueElem = root.element(ENCRYPTED_VALUE);
        String sEncodedEncryptedData = encryptedValueElem.getText();
        byte[] encodedData = sEncodedEncryptedData.getBytes(CREDENTIALS_XML_ENCODING);
        byte[] encryptedData = Base64.getDecoder().decode(encodedData);
        dencryptedData = this.es.decryptData(encryptedData);
        return dencryptedData;
    }

    protected String[] getUsernameAndPasswordFromPropertyValue(byte[] decryptedCredentials) throws Exception {
        String[] usernameAndPassword = new String[2];
        String credentialsString = new String(decryptedCredentials, CREDENTIALS_XML_ENCODING);
        Element root = DocumentHelper.parseText((String)credentialsString).getRootElement();
        usernameAndPassword[0] = root.elementText(ELEM_CREDENTIALS_USERNAME);
        usernameAndPassword[1] = root.elementText(ELEM_CREDENTIALS_PASSWORD);
        return usernameAndPassword;
    }

    public String createBasicAuthenticationCredentials(String sEncodedEncryptedCredentials) throws Exception {
        String[] usernameAndPassword = this.createCredentialsPropertiesFromPropertyValue(sEncodedEncryptedCredentials);
        String userName = usernameAndPassword[0];
        String password = usernameAndPassword[1];
        String userCredentials = userName + BASIC_AUTHENTICATION_SEPARATOR + password;
        return new String(Base64.getEncoder().encode(userCredentials.getBytes()), CREDENTIALS_XML_ENCODING);
    }

    public String[] createCredentialsPropertiesFromPropertyValue(String sEncodedEncryptedCredentials) throws Exception {
        byte[] decryptedCredentials = this.decryptCredentialsFromPropertyValue(sEncodedEncryptedCredentials);
        return this.getUsernameAndPasswordFromPropertyValue(decryptedCredentials);
    }

    public String createEncodedCredentials(String userName, String password) throws Exception {
        String userCredentials = userName + BASIC_AUTHENTICATION_SEPARATOR + password;
        return new String(Base64.getEncoder().encode(userCredentials.getBytes()), CREDENTIALS_XML_ENCODING);
    }

    public String[] createEncryptedCredentials(String decryptedUserName, String decryptedPassword) throws Exception {
        String[] credentials = new String[]{new String(this.es.encryptData(decryptedUserName.getBytes())), new String(this.es.encryptData(decryptedPassword.getBytes()))};
        return credentials;
    }
}

