/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.reflect;

import java.lang.reflect.Field;

public class FieldAccessor<E> {
    private final Object target;
    private final Field f;

    public FieldAccessor(Object target, String fieldName) {
        this(target instanceof Class ? (Class<?>)target : target.getClass(), target, fieldName);
    }

    public FieldAccessor(Class<?> c, Object target, String fieldName) {
        this.target = target;
        try {
            this.f = this.findField(c, fieldName);
            if (this.f == null) {
                throw new RuntimeException("Could not find field: " + fieldName);
            }
            this.f.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private Field findField(Class<?> c, String fieldName) {
        Field field = null;
        while (field == null && !c.equals(Object.class)) {
            try {
                field = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                c = c.getSuperclass();
            }
        }
        return field;
    }

    public E get() {
        try {
            return (E)this.f.get(this.target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void set(E value) {
        try {
            this.f.set(this.target, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

