/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.resource;

import com.cognos.cmutils.io.CMStreamUtils;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;

public abstract class AbstractResourceLoader
implements CMResourceLoader {
    protected abstract ClassLoader getClassLoader();

    @Override
    public InputStream getResourceInputStream(String resourcePath) {
        return this.getClassLoader().getResourceAsStream(this.getRelativePath(resourcePath));
    }

    @Override
    public String[] listResourceNames(String resourcePath) {
        String[] list = null;
        String relativePath = this.getRelativePath(resourcePath);
        try {
            URL dirURL = this.getClassLoader().getResource(relativePath);
            if (dirURL != null) {
                File file = new File(dirURL.toURI());
                list = file.list();
            }
        }
        catch (URISyntaxException e) {
            list = null;
        }
        if (list != null) {
            Arrays.sort(list);
        }
        return list;
    }

    public String loadResourceIntoString(String resourcePath) {
        InputStream inStream = this.getResourceInputStream(resourcePath);
        if (inStream == null) {
            throw new RuntimeException("Resource not found: " + resourcePath);
        }
        try {
            return new String(CMStreamUtils.readInputStreamIntoByteArray(inStream));
        }
        catch (IOException e) {
            throw new RuntimeException("Resource could not be loaded: " + resourcePath, e);
        }
    }

    private String getRelativePath(String resourcePath) {
        String relativePath = resourcePath.startsWith("/") ? resourcePath.substring(1) : resourcePath;
        return relativePath;
    }
}

