/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.setting;

import com.cognos.cmutils.setting.Fetcher;
import java.lang.reflect.Field;

public class AdvancedSettingsFetcher
implements Fetcher {
    private static final String DEFAULT_ADVANCED_SETTINGS_CLASS = "com.cognos.cm.server.AdvancedSettings";
    private static String advancedSettingsClass = "com.cognos.cm.server.AdvancedSettings";
    private static boolean loadAttempted = false;
    private static Class<?> advancedSettings;
    private Object value;

    @Override
    public Object getValue() {
        return this.value;
    }

    public AdvancedSettingsFetcher(String advancedSettingName) {
        Field advancedSettingValue;
        Class<?> advancedSettings = this.getAdvancedSettingsClass();
        if (advancedSettings != null && (advancedSettingValue = this.getField(advancedSettingName, advancedSettings)) != null) {
            Object value;
            this.value = value = this.getAdvancedSettingsValue(advancedSettings, advancedSettingValue);
        }
    }

    private Object getAdvancedSettingsValue(Class<?> advancedSettings, Field advancedSettingValue) {
        Object value = null;
        try {
            value = advancedSettingValue.get(advancedSettings);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return value;
    }

    private Field getField(String advancedSettingName, Class<?> advancedSettings) {
        Field advancedSettingValue = null;
        try {
            advancedSettingValue = advancedSettings.getField(advancedSettingName);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return advancedSettingValue;
    }

    private Class<?> getAdvancedSettingsClass() {
        if (advancedSettings == null && !loadAttempted) {
            advancedSettings = AdvancedSettingsFetcher.loadAdvancedSettingsClass();
            loadAttempted = true;
        }
        return advancedSettings;
    }

    private static synchronized Class<?> loadAdvancedSettingsClass() {
        Class<?> advancedSettings = null;
        try {
            advancedSettings = Class.forName(advancedSettingsClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return advancedSettings;
    }

    public static void setAdvancedSettingsClass_test(String testClass) {
        advancedSettingsClass = testClass;
    }

    public static void reset() {
        advancedSettingsClass = DEFAULT_ADVANCED_SETTINGS_CLASS;
        advancedSettings = null;
        loadAttempted = false;
    }
}

