/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.tempcache;

import java.util.HashMap;

public class CMManyReadersOneWriterLock {
    Handle handle_ = new Handle();
    int waitingReaders_;
    HashMap<Thread, Integer> currentReaders_ = new HashMap();
    int writerLocks_;
    int waitingWriters_;
    Thread writeOwner_;

    public static final void safeRelease(Handle h) {
        try {
            if (h != null) {
                h.relinquish();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Handle acquireRead() throws InterruptedException {
        ++this.waitingReaders_;
        Thread currentThread = Thread.currentThread();
        try {
            Integer threadLocalCount = this.currentReaders_.get(currentThread);
            if (threadLocalCount != null) {
                this.currentReaders_.put(currentThread, new Integer(threadLocalCount + 1));
                Handle handle = this.handle_;
                return handle;
            }
            if (this.writeOwner_ == currentThread) {
                ++this.writerLocks_;
                Handle handle = this.handle_;
                return handle;
            }
            while (this.writeOwner_ != null || this.waitingWriters_ > 0) {
                this.wait();
            }
            this.currentReaders_.put(currentThread, new Integer(1));
        }
        finally {
            --this.waitingReaders_;
        }
        return this.handle_;
    }

    public synchronized Handle acquireWrite() throws InterruptedException {
        ++this.waitingWriters_;
        try {
            Thread currentThread = Thread.currentThread();
            if (this.writeOwner_ == currentThread) {
                ++this.writerLocks_;
                Handle handle = this.handle_;
                return handle;
            }
            Integer threadLocalCount = this.currentReaders_.get(currentThread);
            if (threadLocalCount != null) {
                throw new IllegalStateException("Cannot acquire a Write lock because the current thread already has a read lock.");
            }
            while (this.currentReaders_.size() > 0 || this.writeOwner_ != null) {
                this.wait();
            }
            this.writeOwner_ = currentThread;
            this.writerLocks_ = 1;
        }
        finally {
            --this.waitingWriters_;
        }
        return this.handle_;
    }

    public synchronized void release() {
        Thread currentThread = Thread.currentThread();
        if (this.writeOwner_ != null) {
            if (this.writeOwner_ != currentThread) {
                throw new IllegalStateException("An attempt to release the lock was attempted by a thread other than an owning thread.");
            }
            --this.writerLocks_;
            if (this.writerLocks_ == 0) {
                this.writeOwner_ = null;
                this.notifyAll();
            }
        } else {
            Integer threadLocalLockCountObj = this.currentReaders_.get(currentThread);
            if (threadLocalLockCountObj == null) {
                throw new IllegalStateException("An attempt to release the lock was attempted by a thread other than an owning thread.");
            }
            int threadLocalLockCount = threadLocalLockCountObj - 1;
            if (threadLocalLockCount == 0) {
                this.currentReaders_.remove(currentThread);
                this.notifyAll();
            } else {
                this.currentReaders_.put(currentThread, new Integer(threadLocalLockCount));
            }
        }
    }

    public synchronized boolean hasWrite() {
        return this.writeOwner_ != null;
    }

    public synchronized boolean hasRead() {
        return this.currentReaders_.size() > 0;
    }

    public final class Handle {
        public void relinquish() {
            CMManyReadersOneWriterLock.this.release();
        }
    }
}

