/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.tempcache;

import com.cognos.cmutils.io.CMStreamUtils;
import com.cognos.cmutils.tempcache.CMTempFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;

public class CMTempDataReaderWriter {
    InputStream dataStream_;
    Reader reader_;
    OutputStream outputStream_;
    OutputStreamWriter outputStreamW_;
    char[] bufferChars_;
    byte[] bufferBytes_;

    public CMTempDataReaderWriter(InputStream dataStream) {
        this.dataStream_ = dataStream;
    }

    public CMTempDataReaderWriter(Reader reader) {
        this.reader_ = reader;
    }

    protected boolean isInputStream() {
        return this.dataStream_ != null && this.reader_ == null;
    }

    protected boolean isReader() {
        return this.dataStream_ == null && this.reader_ != null;
    }

    void prepareForWriting(CMTempFile tempFile) throws Exception {
        if (this.isReader()) {
            this.outputStream_ = tempFile.getOutputStream();
            try {
                this.outputStreamW_ = new OutputStreamWriter(this.outputStream_, "UTF-8");
            }
            catch (Exception ex) {
                this.outputStreamW_ = new OutputStreamWriter(this.outputStream_);
            }
        } else if (this.isInputStream()) {
            this.outputStream_ = tempFile.getOutputStream();
        }
    }

    void prepareForReading() throws Exception {
        if (this.isReader()) {
            this.bufferChars_ = new char[32768];
        } else if (this.isInputStream()) {
            this.bufferBytes_ = new byte[32768];
        }
    }

    protected int readChunk() throws Exception {
        int numRead = 0;
        if (this.isReader()) {
            numRead = this.reader_.read(this.bufferChars_);
        } else if (this.isInputStream()) {
            numRead = this.dataStream_.read(this.bufferBytes_);
        }
        return numRead;
    }

    protected void writeChunk(int numRead) throws Exception {
        if (this.isReader()) {
            this.outputStreamW_.write(this.bufferChars_, 0, numRead);
        } else if (this.isInputStream()) {
            this.outputStream_.write(this.bufferBytes_, 0, numRead);
        }
    }

    protected void flush() throws IOException {
        if (this.isReader()) {
            this.outputStreamW_.flush();
        } else if (this.isInputStream()) {
            this.outputStream_.flush();
        }
    }

    protected void close() throws IOException {
        if (this.isReader()) {
            CMStreamUtils.quietClose(this.reader_);
            if (this.outputStreamW_ != null) {
                this.outputStreamW_.close();
            }
        } else if (this.isInputStream() && this.outputStream_ != null) {
            this.outputStream_.close();
        }
    }

    protected char[] getBufferCharacters() {
        return this.bufferChars_;
    }

    protected byte[] getBufferBytes() {
        return this.bufferBytes_;
    }
}

