/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.tempcache;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.TmpCipherStreamSession;
import com.cognos.cmutils.tempcache.CMManyReadersOneWriterLock;
import com.cognos.cmutils.tempcache.CMTempFileInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CMTempFile {
    private static final int INMEMORY_THRESHOLD = 524288;
    private boolean isAppendable = false;
    private File file = null;
    private long contentSize = 0L;
    private int threshold = 524288;
    private TempFileBufferedOutputStream bufferedOS = null;
    private CMManyReadersOneWriterLock readWriteLock = null;
    private Map<String, Object> metadataMap = new HashMap<String, Object>();
    private TmpCipherStreamSession tempFileCipherSession = null;
    private Integer fileLockCount = 1;
    private static Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor(CMTempFile.class.getName());

    private CMTempFile() {
    }

    protected CMTempFile(String path, TmpCipherStreamSession tempFileCipherSession) {
        this();
        this.file = new File(path);
        this.tempFileCipherSession = tempFileCipherSession;
    }

    protected CMTempFile(String path, int threshold, TmpCipherStreamSession tempFileCipherSession) throws FileNotFoundException {
        this(path, tempFileCipherSession);
        this.threshold = threshold;
        this.readWriteLock = new CMManyReadersOneWriterLock();
        TempFileBaseOutputStream fos = new TempFileBaseOutputStream(this);
        this.bufferedOS = new TempFileBufferedOutputStream(fos, this.threshold);
        this.isAppendable = true;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        InputStream input = this.bufferedOS == null || !this.isAppendable ? new FileInputStream(this.file) : new CMTempFileInputStream(this);
        try {
            if (this.isTempFileEncrypted()) {
                input = this.tempFileCipherSession.createDecryptingInputStream(input);
            }
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        return input;
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        OutputStream output;
        if (this.bufferedOS == null) {
            output = new FileOutputStream(this.file);
        } else if (this.isAppendable) {
            output = this.bufferedOS;
        } else {
            throw new IllegalStateException("CMTempFile OutputStream is requested when writing is finished");
        }
        try {
            if (this.isTempFileEncrypted()) {
                output = this.tempFileCipherSession.createEncryptingOutputStream(output);
            }
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        return output;
    }

    private boolean isTempFileEncrypted() {
        return this.tempFileCipherSession != null;
    }

    public synchronized void close() {
        this.isAppendable = false;
    }

    public CMManyReadersOneWriterLock getLock() {
        return this.readWriteLock;
    }

    public File getFile() {
        return this.file;
    }

    public synchronized void notifyMoreWritten() {
        this.notifyAll();
    }

    public synchronized boolean waitMoreWritten() {
        boolean hasWaited;
        if (!this.isAppendable) {
            return false;
        }
        try {
            this.wait();
            hasWaited = true;
        }
        catch (InterruptedException e) {
            hasWaited = false;
        }
        return hasWaited;
    }

    public byte[] getBuffer() {
        return this.bufferedOS.getBuffer();
    }

    public int getBufferLength() {
        return this.bufferedOS.getCount();
    }

    public String toString() {
        String ret = "CMTempFile(fileName=" + this.file + ", appendable=" + this.isAppendable + ", fileLength=" + this.getLength() + ", contentSize=" + this.getContentSize() + ")";
        return ret;
    }

    public long getLength() {
        return this.file.length();
    }

    public void incrContentSize(int bytes) {
        this.contentSize += (long)bytes;
    }

    public void setContentSize(long bytes) {
        this.contentSize = bytes;
    }

    public long getContentSize() {
        return this.contentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        boolean shouldLog = false;
        boolean shouldDelete = false;
        Integer n = this.fileLockCount;
        synchronized (n) {
            if (this.fileLockCount > 0) {
                CMTempFile cMTempFile = this;
                Integer n2 = cMTempFile.fileLockCount;
                Integer n3 = cMTempFile.fileLockCount = Integer.valueOf(cMTempFile.fileLockCount - 1);
                shouldDelete = this.fileLockCount == 0;
            } else {
                shouldLog = true;
            }
        }
        if (shouldDelete) {
            this.deleteFile();
        }
        if (shouldLog) {
            this.logWarningMessage("A temp file is being released even though there are no locks on it.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLock() {
        boolean shouldLog = false;
        Integer n = this.fileLockCount;
        synchronized (n) {
            if (this.fileLockCount > 0) {
                CMTempFile cMTempFile = this;
                Integer n2 = cMTempFile.fileLockCount;
                Integer n3 = cMTempFile.fileLockCount = Integer.valueOf(cMTempFile.fileLockCount + 1);
            } else {
                shouldLog = true;
            }
        }
        if (shouldLog) {
            this.logWarningMessage("A lock was placed on a temp file after it was deleted.");
        }
    }

    private boolean deleteFile() {
        boolean isDeleted = this.file.delete();
        if (!isDeleted) {
            this.logWarningMessage("An error occurred while attempting to delete a temp file.");
        }
        return isDeleted;
    }

    private void logWarningMessage(String msg) {
        log.debug(msg);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.fileLockCount > 0) {
                this.deleteFile();
                this.logWarningMessage("Number of locks not released for a temp file: " + this.fileLockCount + ".");
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isFileLocked() {
        boolean isFileLocked;
        Integer n = this.fileLockCount;
        synchronized (n) {
            isFileLocked = this.fileLockCount > 0;
        }
        return isFileLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean forceDeleteFile() {
        Integer n = this.fileLockCount;
        synchronized (n) {
            this.fileLockCount = 0;
        }
        return this.deleteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getFileLockCount() {
        int fileLockCount;
        Integer n = this.fileLockCount;
        synchronized (n) {
            fileLockCount = this.fileLockCount;
        }
        return fileLockCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLocksWithoutLogging() {
        Integer n = this.fileLockCount;
        synchronized (n) {
            this.fileLockCount = 0;
        }
        this.file.delete();
    }

    public void setMetadata(String name, Object value) {
        this.metadataMap.put(name, value);
    }

    public Object getMetadata(String name) {
        return this.metadataMap.get(name);
    }

    public boolean hasMetadata(String name) {
        return this.metadataMap.containsKey(name);
    }

    public class TempFileBaseOutputStream
    extends FileOutputStream {
        private CMTempFile tempFile_;

        TempFileBaseOutputStream(CMTempFile tempFile) throws FileNotFoundException {
            super(tempFile.getFile());
            try {
                super.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tempFile_ = tempFile;
        }

        @Override
        public void write(int b) throws IOException {
            try (FileOutputStream fileOS = null;){
                fileOS = new FileOutputStream(this.tempFile_.getFile());
                fileOS.write(b);
            }
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buffer, int offset, int length) throws IOException {
            if (buffer == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || offset + length > buffer.length) {
                throw new IndexOutOfBoundsException();
            }
            if (length == 0) {
                return;
            }
            try (FileOutputStream fileOS = null;){
                fileOS = new FileOutputStream(this.tempFile_.getFile().getAbsolutePath(), true);
                fileOS.write(buffer, offset, length);
                fileOS.close();
            }
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }
    }

    class TempFileBufferedOutputStream
    extends BufferedOutputStream {
        public TempFileBufferedOutputStream(OutputStream os, int size) {
            super(os, size);
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }
}

