/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.tempcache;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.TmpCipherStreamSession;
import com.cognos.cmutils.tempcache.CMTempFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMTempFileFactory {
    private String prefix = "cm_temp_";
    private String suffix = null;
    private File directory = null;
    private TmpCipherStreamSession tempFileCipherSession = null;
    private static CMTempFileFactory factory = new CMTempFileFactory();
    public static final String TEMP_FILE_PREFIX_DEFAULT = "cm_temp_";
    public static final int STREAM_BUFFER_SIZE = 32768;

    public static void init(String prefix, File dir, TmpCipherStreamSession tempFileCipherSession) {
        CMTempFileFactory tempFileFactory;
        factory = tempFileFactory = new CMTempFileFactory(prefix, dir, tempFileCipherSession);
    }

    public static CMTempFileFactory getInstance() {
        return factory;
    }

    public CMTempFileFactory() {
    }

    public CMTempFileFactory(String prefix, File dir) {
        this();
        this.prefix = prefix;
        this.directory = dir;
    }

    public CMTempFileFactory(String prefix, File dir, TmpCipherStreamSession tempFileCipherSession) {
        this(prefix, dir);
        this.tempFileCipherSession = tempFileCipherSession;
    }

    public File createTempFile() throws IOException {
        return File.createTempFile(this.prefix, this.suffix, this.directory);
    }

    public CMTempFile createCMTempFile(int threshold) throws IOException {
        File tempFile = this.createTempFile();
        return new CMTempFile(tempFile.getAbsolutePath(), threshold, this.tempFileCipherSession);
    }

    public CMTempFile createCMTempFile(String path) {
        return new CMTempFile(path, this.tempFileCipherSession);
    }

    public CMTempFile createCMTempFile(File file) {
        return this.createCMTempFile(file.getAbsolutePath());
    }

    public CMTempFile createCMTempFile() throws IOException {
        File tempFile = this.createTempFile();
        return this.createCMTempFile(tempFile.getAbsolutePath());
    }

    public boolean isEncryptionActive() {
        return this.tempFileCipherSession != null;
    }

    public OutputStream getOutputStream(File file) throws IOException {
        OutputStream outputStream = new FileOutputStream(file);
        try {
            if (this.isEncryptionActive()) {
                outputStream = new BufferedOutputStream(outputStream, 32768);
                outputStream = this.tempFileCipherSession.createEncryptingOutputStream(outputStream);
            }
        }
        catch (CAMCryptoException e) {
            throw new IOException(e.getMessage());
        }
        return outputStream;
    }

    public InputStream getInputStream(File file) throws IOException {
        InputStream inputStream = new FileInputStream(file);
        try {
            if (this.isEncryptionActive()) {
                inputStream = new BufferedInputStream(inputStream, 32768);
                inputStream = this.tempFileCipherSession.createDecryptingInputStream(inputStream);
            }
        }
        catch (CAMCryptoException e) {
            throw new IOException(e.getMessage());
        }
        return inputStream;
    }
}

