/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.tempcache;

import com.cognos.cmutils.tempcache.CMTempFile;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMTempFileInputStream
extends InputStream {
    private FileInputStream fileIS_ = null;
    private long nextByteIndex = 0L;
    private CMTempFile tempFile_;
    private byte[] oneByteBuffer_ = new byte[1];

    CMTempFileInputStream(CMTempFile tempFile) {
        this.tempFile_ = tempFile;
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.oneByteBuffer_, 0, 1) > 0) {
            return this.oneByteBuffer_[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        int result = -1;
        int resultFromFile = 0;
        int resultFromBuffer = 0;
        int offsetInternal = offset;
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        int bytesToRead = len;
        if (bytesToRead == 0) {
            return 0;
        }
        try {
            boolean bCanReadData = false;
            while (!bCanReadData) {
                this.tempFile_.getLock().acquireRead();
                if (this.nextByteIndex + (long)bytesToRead <= this.tempFile_.getLength() + (long)this.tempFile_.getBufferLength()) {
                    bCanReadData = true;
                    break;
                }
                this.tempFile_.getLock().release();
                if (!this.tempFile_.waitMoreWritten()) {
                    bCanReadData = true;
                    this.tempFile_.getLock().acquireRead();
                    break;
                }
                if (this.fileIS_ == null) continue;
                this.fileIS_.close();
                this.fileIS_ = null;
            }
            try {
                if (this.tempFile_.getFile() != null && this.tempFile_.getLength() > 0L && this.fileIS_ == null) {
                    this.fileIS_ = new FileInputStream(this.tempFile_.getFile());
                    int c = 0;
                    for (long skipped = this.fileIS_.skip(this.nextByteIndex); c >= 0 && skipped < this.nextByteIndex; ++skipped) {
                        c = this.fileIS_.read();
                    }
                }
                int bytesToReadFromFile = 0;
                if (this.nextByteIndex < this.tempFile_.getLength()) {
                    bytesToReadFromFile = this.nextByteIndex + (long)bytesToRead <= this.tempFile_.getLength() ? bytesToRead : (int)(this.tempFile_.getLength() - this.nextByteIndex);
                }
                int bytesToReadFromBuffer = 0;
                if (bytesToRead > bytesToReadFromFile) {
                    bytesToReadFromBuffer = bytesToRead - bytesToReadFromFile;
                }
                if (bytesToReadFromFile > 0 && this.fileIS_ != null) {
                    resultFromFile = this.fileIS_.read(buffer, offset, bytesToReadFromFile);
                    if (resultFromFile < bytesToReadFromFile) {
                        result = resultFromFile;
                        bytesToReadFromBuffer = 0;
                    } else if (resultFromFile > 0) {
                        result = resultFromFile;
                    }
                    if (resultFromFile > 0) {
                        this.nextByteIndex += (long)resultFromFile;
                        offsetInternal += resultFromFile;
                    }
                }
                byte[] fileBuffer = this.tempFile_.getBuffer();
                int fileBufferLength = this.tempFile_.getBufferLength();
                int fileBufferFirstByteIndex = (int)(this.nextByteIndex - this.tempFile_.getLength());
                if (bytesToReadFromBuffer > 0 && fileBuffer != null) {
                    resultFromBuffer = Math.min(fileBufferLength - fileBufferFirstByteIndex, bytesToReadFromBuffer);
                    if ((resultFromBuffer = Math.min(resultFromBuffer, buffer.length - offsetInternal)) > 0) {
                        System.arraycopy(fileBuffer, fileBufferFirstByteIndex, buffer, offsetInternal, resultFromBuffer);
                        result += resultFromBuffer;
                        this.nextByteIndex += (long)resultFromBuffer;
                    }
                }
            }
            finally {
                this.tempFile_.getLock().release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.fileIS_ != null) {
            this.fileIS_.close();
            this.fileIS_ = null;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.nextByteIndex += n;
        return n;
    }
}

