/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.tempcache;

import com.cognos.cmutils.config.ConfigurationException;
import com.cognos.cmutils.tempcache.CMTempDataReaderWriter;
import com.cognos.cmutils.tempcache.CMTempFile;
import com.cognos.cmutils.tempcache.CMTempFileCacheBase;
import com.cognos.cmutils.tempcache.CMTempFileFactory;
import com.cognos.cmutils.values.CMInt;
import com.cognos.perfMonitor.PerfCounter;
import com.cognos.perfMonitor.PerfMeasure;
import com.cognos.perfMonitor.PerfMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CMTempFileLRUCacheBase
implements CMTempFileCacheBase {
    public static final int BYTES_IN_KILOBYTES = 1024;
    private static Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor(CMTempFileLRUCacheBase.class.getName());
    private static final PerfMeasure CURRENT_KBYTES = PerfMonitor.getMeasure("com.cognos.cm.util.CMTempFileLRUCache.currentKByteSize", "The current size of the temp file LRU cache in kbytes.", 6);
    private static final PerfCounter TEMPFILELRUCACHE_HITS = PerfMonitor.getCounter("com.cognos.cm.util.CMTempFileLRUCache.hits", "The number of TempFile LRU cache hits", 6);
    private static final PerfCounter TEMPFILELRUCACHE_MISSES = PerfMonitor.getCounter("com.cognos.cm.util.CMTempFileLRUCache.misses", "The number of TempFile LRU cache misses", 6);
    public static final String TEMP_FILE_LAST_ACCESSED = "lastAccessed";
    public static final String TEMP_FILE_CACHE_KEY = "tempFileCacheKey";
    public static final String TEMP_FILE_DATA_SIZE = "tempFileDataSize";
    private CMTempFileFactory tempFileFactory = null;
    private CMInt maxKByteSize = null;
    private int currentKByteSize = 0;
    private long fileLifeTimeMinutes = -1L;
    private static final boolean DO_DEBUG = false;
    private Map<Object, CMTempFile> entries = new CMTempFileLRUMap<Object, CMTempFile>(100, 0.75f, true);
    public static final String ERR_MSG_DATA_READER_CLOSE = "An error occurred while trying to close data reader.";
    public static final String ERR_MSG_ADD_TMP_FILE = "An error occured while trying to add a new temp file.";

    private CMTempFileLRUCacheBase() {
    }

    public CMTempFileLRUCacheBase(CMTempFileFactory tempFileFactory, int maxSize, int fileLifeTimeMinutes) {
        this(tempFileFactory, new CMInt(maxSize), fileLifeTimeMinutes);
    }

    public CMTempFileLRUCacheBase(CMTempFileFactory tempFileFactory, CMInt maxSize, int fileLifeTimeMinutes) {
        this();
        this.tempFileFactory = tempFileFactory;
        this.maxKByteSize = maxSize;
        this.currentKByteSize = 0;
        this.fileLifeTimeMinutes = fileLifeTimeMinutes;
    }

    @Override
    public boolean add(Object key, String filePath, boolean bLockEntry) {
        boolean isSuccess;
        File file = new File(filePath);
        long fileSize = file.length();
        File newFile = null;
        try {
            newFile = this.tempFileFactory.createTempFile();
            newFile.delete();
            isSuccess = file.renameTo(newFile);
            String newFilePath = newFile.getAbsolutePath();
            if (isSuccess) {
                this.freeSpaceForBytes(fileSize);
                CMTempFile tempFile = this.tempFileFactory.createCMTempFile(newFilePath);
                this.addTempFileToCache(key, tempFile, bLockEntry, fileSize);
            }
        }
        catch (IOException ioe) {
            log.error(ERR_MSG_ADD_TMP_FILE, (Throwable)ioe);
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public CMTempFile add(Object key, CMTempDataReaderWriter dataReaderWriter, String contentType, boolean bLockAndReturn) throws ConfigurationException {
        CMTempFile tmpFile = null;
        try {
            tmpFile = this.tempFileFactory.createCMTempFile();
            long dataSize = this.doDataReadWrite(dataReaderWriter, tmpFile);
            this.addTempFileToCache(key, tmpFile, bLockAndReturn, dataSize);
        }
        catch (Exception e) {
            if (tmpFile != null) {
                tmpFile.release();
            }
            throw new ConfigurationException(ERR_MSG_ADD_TMP_FILE, e);
        }
        finally {
            try {
                dataReaderWriter.close();
            }
            catch (Exception ex) {
                log.error(ERR_MSG_DATA_READER_CLOSE, (Throwable)ex);
            }
        }
        CMTempFile ret = bLockAndReturn ? tmpFile : null;
        return ret;
    }

    private synchronized void addTempFileToCache(Object key, CMTempFile tmpFile, boolean bLockAndReturn, long dataSize) {
        tmpFile.setMetadata(TEMP_FILE_DATA_SIZE, dataSize);
        this.addEntry(key, tmpFile, bLockAndReturn);
        this.bytesWritten(tmpFile);
    }

    @Override
    public CMTempFile add(Object key, InputStream dataStream, String contentType, boolean bLockAndReturn) throws ConfigurationException {
        CMTempDataReaderWriter dataReaderWriter = new CMTempDataReaderWriter(dataStream);
        CMTempFile ret = this.add(key, dataReaderWriter, contentType, bLockAndReturn);
        return ret;
    }

    private long doDataReadWrite(CMTempDataReaderWriter dataReaderWriter, CMTempFile tmpFile) throws ConfigurationException {
        long numTotalBytesRead = 0L;
        try {
            dataReaderWriter.prepareForWriting(tmpFile);
            dataReaderWriter.prepareForReading();
            int numRead = dataReaderWriter.readChunk();
            while (numRead > 0) {
                numTotalBytesRead += (long)numRead;
                this.freeSpaceForBytes(numRead);
                dataReaderWriter.writeChunk(numRead);
                numRead = dataReaderWriter.readChunk();
            }
            dataReaderWriter.close();
        }
        catch (IOException e) {
            throw new ConfigurationException(ERR_MSG_ADD_TMP_FILE, e);
        }
        catch (Exception e) {
            throw new ConfigurationException(ERR_MSG_ADD_TMP_FILE, e);
        }
        finally {
            try {
                dataReaderWriter.close();
            }
            catch (Exception ex) {
                log.error(ERR_MSG_DATA_READER_CLOSE, (Throwable)ex);
            }
        }
        return numTotalBytesRead;
    }

    protected synchronized void releaseTempFile(CMTempFile entry) {
        this.bytesDeleted(entry.getLength());
        entry.release();
    }

    @Override
    public synchronized boolean remove(Object key) {
        boolean isEntryRemoved;
        CMTempFile entry = this.entries.remove(key);
        boolean bl = isEntryRemoved = entry != null;
        if (isEntryRemoved) {
            this.releaseTempFile(entry);
        }
        return isEntryRemoved;
    }

    @Override
    public synchronized void removeAll() {
        HashSet<Object> entryCopy = new HashSet<Object>(this.entries.keySet());
        for (Object e : entryCopy) {
            this.remove(e);
        }
    }

    @Override
    public CMTempFile get(Object key) {
        CMTempFile tempFile;
        CMTempFile entry = this.lockEntry(key);
        if (entry == null) {
            TEMPFILELRUCACHE_MISSES.incr();
            tempFile = null;
        } else {
            TEMPFILELRUCACHE_HITS.incr();
            File file = entry.getFile();
            if (!file.exists()) {
                entry.release();
                this.remove(key);
                tempFile = null;
            } else {
                tempFile = entry;
            }
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDecryptedDataSize(Object key) {
        long decryptDataSize;
        CMTempFile entry = this.lockEntry(key);
        try {
            if (entry == null) {
                decryptDataSize = 0L;
            } else {
                File file = entry.getFile();
                if (!file.exists()) {
                    this.remove(key);
                    decryptDataSize = 0L;
                } else {
                    decryptDataSize = entry.getContentSize();
                }
            }
        }
        finally {
            if (entry != null) {
                entry.release();
            }
        }
        return decryptDataSize;
    }

    public synchronized boolean freeSpaceForBytes(long bytesNumber) {
        int max = this.maxKByteSize.intValue();
        long kiloBytesNumber = bytesNumber / 1024L;
        Iterator<CMTempFile> mapIt = this.entries.values().iterator();
        while (kiloBytesNumber + (long)this.currentKByteSize > (long)max && mapIt.hasNext()) {
            CMTempFile entry = mapIt.next();
            mapIt.remove();
            this.releaseTempFile(entry);
        }
        return kiloBytesNumber + (long)this.currentKByteSize <= (long)max;
    }

    protected long bytesToKbytes(long bytes) {
        long kbytes = (long)Math.ceil((double)bytes / 1024.0);
        return kbytes;
    }

    public synchronized void bytesWritten(CMTempFile tempFile) {
        long bytes = tempFile.getLength();
        long kbytes = this.bytesToKbytes(bytes);
        this.currentKByteSize = (int)((long)this.currentKByteSize + kbytes);
        CURRENT_KBYTES.incr(kbytes);
    }

    synchronized void bytesDeleted(long bytes) {
        long kbytes = this.bytesToKbytes(bytes);
        this.currentKByteSize = (int)((long)this.currentKByteSize - kbytes);
        CURRENT_KBYTES.decr(kbytes);
    }

    protected synchronized CMTempFile addEntry(Object key, CMTempFile file, boolean bLockEntry) {
        this.remove(key);
        long lastAccessedTime = System.currentTimeMillis() / 60000L;
        file.setMetadata(TEMP_FILE_LAST_ACCESSED, lastAccessedTime);
        file.setMetadata(TEMP_FILE_CACHE_KEY, key);
        this.entries.put(key, file);
        this.touch(file);
        if (bLockEntry) {
            file.addLock();
        }
        return file;
    }

    private synchronized CMTempFile lockEntry(Object key) {
        CMTempFile entry = this.entries.get(key);
        if (entry != null) {
            entry.addLock();
            this.touch(entry);
        }
        return entry;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (CMTempFile iter : this.entries.values()) {
            iter.release();
        }
    }

    public synchronized boolean touchKey(Object key) {
        boolean bRet = false;
        CMTempFile entry = this.entries.get(key);
        if (entry != null) {
            this.touch(entry);
            bRet = true;
        }
        return bRet;
    }

    private synchronized void touch(CMTempFile entry) {
        long curTime = System.currentTimeMillis() / 60000L;
        entry.setMetadata(TEMP_FILE_LAST_ACCESSED, curTime);
    }

    public synchronized String debugDump() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("CMTempFileLRUCache(");
        sbuf.append("hash=" + this.hashCode());
        sbuf.append(", #entries=" + this.entries.size());
        sbuf.append(", currentKByteSize=" + this.currentKByteSize);
        sbuf.append("): entries = {");
        for (Map.Entry<Object, CMTempFile> entry : this.entries.entrySet()) {
            sbuf.append("\n\t");
            sbuf.append(entry.toString());
        }
        sbuf.append("\n};\n");
        return sbuf.toString();
    }

    private void debug(String message1, Object arg1) {
    }

    protected Map<Object, CMTempFile> getEntries() {
        return this.entries;
    }

    protected int getCurrentKBByteSize() {
        return this.currentKByteSize;
    }

    protected CMTempFile getTail() {
        CMTempFile tail = this.entries.isEmpty() ? null : this.entries.values().iterator().next();
        return tail;
    }

    protected boolean hasEntry(Object key) {
        return this.entries.containsKey(key);
    }

    private class CMTempFileLRUMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -6150820769602996150L;
        private CMTempFileLRUCacheBase cache;

        public CMTempFileLRUMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder);
            this.cache = CMTempFileLRUCacheBase.this;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            V value = eldest.getValue();
            if (value instanceof CMTempFile) {
                CMTempFile tailEntry = (CMTempFile)value;
                long curTime = System.currentTimeMillis() / 60000L;
                long tailLastAccessed = (Long)tailEntry.getMetadata(CMTempFileLRUCacheBase.TEMP_FILE_LAST_ACCESSED);
                Object tailKey = tailEntry.getMetadata(CMTempFileLRUCacheBase.TEMP_FILE_CACHE_KEY);
                if (tailLastAccessed + this.cache.fileLifeTimeMinutes < curTime) {
                    this.cache.remove(tailKey);
                }
            }
            return false;
        }
    }
}

