/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.url;

import com.cognos.cmutils.system.SystemUtils;
import java.net.URI;

public class FileURIUtils {
    private static final String FILE_SCHEME = "file";
    private static final String UNC_PREFIX = "\\\\";

    public static String getPathFromURI(String uri) {
        if (null != uri && !uri.isEmpty()) {
            return FileURIUtils.extractPathFromURI(uri);
        }
        return null;
    }

    private static String extractPathFromURI(String uriString) {
        URI uri = URI.create(uriString);
        if (!FILE_SCHEME.equalsIgnoreCase(uri.getScheme())) {
            throw new IllegalArgumentException("Invalid URI scheme : '" + uri.getScheme() + "'. URI scheme 'file' is expected.");
        }
        StringBuilder path = new StringBuilder();
        String uriPath = uri.getPath();
        if (SystemUtils.isRunningWindows()) {
            String authority = uri.getAuthority();
            if (authority != null) {
                path.append(UNC_PREFIX + authority);
            } else if (uriPath.startsWith("/")) {
                uriPath = uriPath.substring(1);
            }
        }
        path.append(uriPath);
        return path.toString();
    }
}

