/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.values;

public class CMInt {
    public static final String GIGABYTE = "GB";
    public static final String MEGABYTE = "MB";
    public static final String KILOBYTE = "KB";
    private int theInt = 0;
    private static final MeasurementUnit[] measurementUnits = new MeasurementUnit[]{new MeasurementUnit("GB", 0x40000000), new MeasurementUnit("MB", 0x100000), new MeasurementUnit("KB", 1024)};

    public CMInt(int i) {
        this.theInt = i;
    }

    public CMInt(String iStr) {
        this.theInt = this.getIntegerValue(iStr);
    }

    public CMInt(int size, String unit) {
        MeasurementUnit sh = this.getMeasurementUnit(unit);
        if (sh == null) {
            throw new UnsupportedOperationException("Unknown unit: " + unit);
        }
        this.theInt = size * sh.getSizeFactor();
    }

    private MeasurementUnit getMeasurementUnit(String unit) {
        for (int i = 0; i < measurementUnits.length; ++i) {
            if (!measurementUnits[i].getMeasureUnit().equals(unit)) continue;
            return measurementUnits[i];
        }
        return null;
    }

    public int intValue() {
        return this.theInt;
    }

    public void setValue(int i) {
        this.theInt = i;
    }

    public void setValue(String value) {
        this.theInt = this.getIntegerValue(value);
    }

    public String toString() {
        return String.valueOf(this.theInt);
    }

    private int getIntegerValue(String iStr) {
        int size = this.getMeasurementValue(iStr);
        if (size == -1) {
            return Integer.parseInt(iStr);
        }
        return size;
    }

    private int getMeasurementValue(String iStr) {
        iStr = iStr.trim();
        for (int i = 0; i < measurementUnits.length; ++i) {
            MeasurementUnit sh = measurementUnits[i];
            if (iStr.indexOf(sh.getMeasureUnit()) == -1) continue;
            return this.getSize(iStr, sh);
        }
        return -1;
    }

    private int getSize(String str, MeasurementUnit unit) {
        int pos = str.indexOf(unit.getMeasureUnit());
        if (str.length() > pos + unit.getMeasureUnit().length()) {
            throw new UnsupportedOperationException("The size indicator must be the last element provided");
        }
        int size = Integer.parseInt(str.substring(0, pos).trim());
        return size * unit.getSizeFactor();
    }

    private static final class MeasurementUnit {
        private int sizeFactor_;
        private String unit_;

        public MeasurementUnit(String sh, int dec) {
            this.unit_ = sh;
            this.sizeFactor_ = dec;
        }

        public int getSizeFactor() {
            return this.sizeFactor_;
        }

        public String getMeasureUnit() {
            return this.unit_;
        }
    }
}

