/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cmutils.xml;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.XPath;

public class XMLUtils {
    private static final char[] ENCODED_QUOT = "&quot;".toCharArray();
    private static final char[] ENCODED_AMP = "&amp;".toCharArray();
    private static final char[] ENCODED_APOS = "&apos;".toCharArray();
    private static final char[] ENCODED_LT = "&lt;".toCharArray();
    private static final char[] ENCODED_GT = "&gt;".toCharArray();

    public static String encode(String str) {
        return XMLUtils.escape(str);
    }

    public static String escape(String str) {
        return XMLUtils.escape(str, true);
    }

    public static String escape(String str, boolean attribute) {
        block10: {
            int i;
            if (str == null || str.length() == 0) {
                return "";
            }
            int len = str.length();
            char[] entity = null;
            char[] chars = str.toCharArray();
            for (i = 0; i < len; ++i) {
                char ch = chars[i];
                if (ch == '<') {
                    entity = ENCODED_LT;
                    break;
                }
                if (ch == '>') {
                    entity = ENCODED_GT;
                    break;
                }
                if (ch == '\"') {
                    if (!attribute) continue;
                    entity = ENCODED_QUOT;
                    break;
                }
                if (ch == '&') {
                    entity = ENCODED_AMP;
                    break;
                }
                if (ch != '\'') continue;
                entity = ENCODED_APOS;
                break;
            }
            if (entity == null) break block10;
            StringBuffer buffer = new StringBuffer(len + 64);
            buffer.append(chars, 0, i);
            buffer.append(entity);
            int curPos = ++i;
            while (i < len) {
                block15: {
                    block12: {
                        char ch;
                        block16: {
                            block14: {
                                block13: {
                                    block11: {
                                        ch = chars[i];
                                        if (ch != '<') break block11;
                                        entity = ENCODED_LT;
                                        break block12;
                                    }
                                    if (ch != '>') break block13;
                                    entity = ENCODED_GT;
                                    break block12;
                                }
                                if (ch != '\"') break block14;
                                if (!attribute) break block15;
                                entity = ENCODED_QUOT;
                                break block12;
                            }
                            if (ch != '&') break block16;
                            entity = ENCODED_AMP;
                            break block12;
                        }
                        if (ch != '\'') break block15;
                        entity = ENCODED_APOS;
                    }
                    buffer.append(chars, curPos, i - curPos);
                    buffer.append(entity);
                    curPos = i + 1;
                }
                ++i;
            }
            buffer.append(chars, curPos, len - curPos);
            str = buffer.toString();
        }
        return str;
    }

    public static String decode(String str) {
        return XMLUtils.unescape(str);
    }

    public static String unescape(String str) {
        if (str == null || str.length() < 1) {
            return "";
        }
        int len = str.length();
        int i = str.indexOf(38);
        if (i < 0) {
            return str;
        }
        int curPos = 0;
        char[] chars = str.toCharArray();
        StringBuffer buffer = new StringBuffer(len);
        try {
            do {
                int elen = 0;
                int ch = 38;
                char cch = chars[i + 1];
                if (cch == 'q') {
                    if (chars[i + 2] == 'u' && chars[i + 3] == 'o' && chars[i + 4] == 't') {
                        elen = 5;
                        ch = 34;
                    }
                } else if (cch == 'a') {
                    cch = chars[i + 2];
                    if (cch == 'm') {
                        if (chars[i + 3] == 'p') {
                            elen = 4;
                            ch = 38;
                        }
                    } else if (cch == 'p' && chars[i + 3] == 'o' && chars[i + 4] == 's') {
                        elen = 5;
                        ch = 39;
                    }
                } else if (cch == 'l') {
                    if (chars[i + 2] == 't') {
                        elen = 3;
                        ch = 60;
                    }
                } else if (cch == 'g' && chars[i + 2] == 't') {
                    elen = 3;
                    ch = 62;
                }
                if (chars[i + elen] == ';') {
                    buffer.append(chars, curPos, i - curPos);
                    buffer.append((char)ch);
                    curPos = i += elen + 1;
                    continue;
                }
                ++i;
            } while ((i = str.indexOf(38, i)) > 0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        buffer.append(chars, curPos, len - curPos);
        return buffer.toString();
    }

    public static List selectNodes(Document doc, String xPath) {
        return doc.selectNodes(xPath);
    }

    public static List selectNodes(Element e, String xPath) {
        return e.selectNodes(xPath);
    }

    public static List selectNodes(XPath x, Object obj) {
        return x.selectNodes(obj);
    }
}

