/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor;

import com.cognos.perfMonitor.PerfMeasure;
import com.cognos.perfMonitor.PerfMonitor;
import com.cognos.perfMonitor.PerfTimer;
import com.cognos.perfMonitor.impl.PerfTimerImpl;
import java.lang.reflect.Method;

public class PerfContext {
    private static ThreadLocal<PerfContext> data = new ThreadLocal<PerfContext>(){

        @Override
        protected PerfContext initialValue() {
            return new PerfContext();
        }
    };
    private boolean bRecording = false;
    private String id = null;

    protected PerfContext() {
    }

    public static PerfContext get() {
        return data.get();
    }

    public void setRecording(boolean b) {
        this.bRecording = b;
    }

    public boolean isRecording() {
        return this.bRecording;
    }

    public void setId(String s) {
        this.id = s;
    }

    public String getId() {
        return this.id;
    }

    public PerfTimer getTimer(PerfTimer otherTimer, Class<?> clazz, Method method) {
        return this.getTimer(otherTimer, clazz.getName() + "." + method.getName());
    }

    public PerfTimer getTimer(PerfTimer otherTimer, String counterName) {
        PerfTimer timer;
        if (this.isRecording()) {
            PerfMeasure altEntry;
            PerfMeasure altMeasure = altEntry = this.getTimer(counterName).getMeasure();
            timer = new PerfTimerWrapper(otherTimer, altMeasure);
        } else {
            timer = otherTimer;
        }
        return timer;
    }

    public PerfTimer getTimer(Class<?> clazz, Method method) {
        return this.getTimer(clazz.getName() + "." + method.getName());
    }

    public PerfTimer getTimer(Class<?> clazz, String methodName) {
        return this.getTimer(clazz.getName() + "." + methodName);
    }

    public PerfTimer getTimer(String counterName) {
        PerfTimer timer;
        if (this.isRecording()) {
            String fqn = "BENCHMARK(" + this.id + ")!" + counterName;
            timer = PerfMonitor.getTimer(fqn);
        } else {
            timer = new PerfTimerNoOp();
        }
        return timer;
    }

    public void reset() {
        this.bRecording = false;
        this.id = null;
    }

    private static class PerfTimerNoOp
    implements PerfTimer {
        private static final PerfMeasure NULL_MEASURE = new PerfMeasure("Time", "", "", 1);

        private PerfTimerNoOp() {
        }

        @Override
        public boolean isStarted() {
            return false;
        }

        @Override
        public void start() {
        }

        @Override
        public long stop() {
            return 0L;
        }

        @Override
        public PerfMeasure getMeasure() {
            return NULL_MEASURE;
        }
    }

    private static class PerfTimerWrapper
    extends PerfTimerImpl {
        private PerfMeasure altMeasure;

        public PerfTimerWrapper(PerfTimer realTimer, PerfMeasure altMeasure) {
            super(realTimer.getMeasure());
            this.altMeasure = altMeasure;
        }

        @Override
        public long stop() {
            long timerResult = super.stop();
            this.altMeasure.incr(timerResult);
            return timerResult;
        }

        @Override
        public PerfMeasure getMeasure() {
            return this.altMeasure;
        }
    }
}

