/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor;

import com.cognos.perfMonitor.PerfCounterTypeEnum;
import com.cognos.perfMonitor.PerfEntry;
import com.cognos.perfMonitor.PerfEntryBean;
import com.cognos.perfMonitor.PerfNotification;
import com.cognos.perfMonitor.impl.PerfOutputFormatUtil;
import java.io.PrintStream;

public class PerfCounter
implements PerfEntry,
PerfEntryBean {
    private final boolean bMandatory;
    private final boolean bPermanent;
    private volatile boolean bEnabled;
    protected String sName = "";
    protected String sDescription = "";
    protected long[] nCount = new long[3];
    protected long[] nCountLastUpdateTime = new long[3];
    private long[] nHighWatermark = new long[3];
    private long[] nHighWatermarkLastUpdateTime = new long[3];
    private long[] nLowWatermark = new long[3];
    private long[] nLowWatermarkLastUpdateTime = new long[3];
    private boolean bDirty = false;
    private boolean bResetingPeriod = false;
    private boolean bResetingAll = false;
    protected PerfNotification mNotification = null;
    protected static final int TOTAL = 0;
    protected static final int LASTPERIOD = 1;
    protected static final int THISPERIOD = 2;
    protected static final int NUMBER_OF_TIME_PERIODS = 3;

    protected PerfCounter(String name, String description, int flags) {
        this.bMandatory = (flags & 2) > 0;
        this.bPermanent = (flags & 4) > 0;
        this.bEnabled = this.bMandatory;
        this.sName = name;
        this.sDescription = description;
        this.setCount(0, 0L);
        this.setCount(2, 0L);
        this.setLowWatermark(0, 0L);
        this.setLowWatermark(2, 0L);
        this.setHighWatermark(0, 0L);
        this.setHighWatermark(2, 0L);
    }

    @Override
    public boolean isPermanent() {
        return this.bPermanent;
    }

    @Override
    public void disable() {
        if (!this.bMandatory) {
            this.bEnabled = false;
        }
    }

    @Override
    public void enable() {
        if (!this.bMandatory) {
            this.bEnabled = true;
        }
    }

    @Override
    public void setEnabled(boolean bEnabled) {
        if (!this.bMandatory) {
            this.bEnabled = bEnabled;
        }
    }

    @Override
    public void setNotificationObject(PerfNotification notif) {
        this.mNotification = notif;
    }

    public String getName() {
        return this.sName;
    }

    @Override
    public String getDescription() {
        return this.sDescription;
    }

    @Override
    public long getTotalCount() {
        return this.nCount[0] + this.nCount[2];
    }

    @Override
    public long getTotalCountLastUpdateTime() {
        if (this.bDirty) {
            return this.nCountLastUpdateTime[2];
        }
        return this.nCountLastUpdateTime[0];
    }

    @Override
    public long getThisPeriodCount() {
        return this.nCount[2];
    }

    @Override
    public long getThisPeriodCountLastUpdateTime() {
        return this.nCountLastUpdateTime[2];
    }

    @Override
    public long getLastPeriodCount() {
        return this.nCount[1];
    }

    @Override
    public long getLastPeriodCountLastUpdateTime() {
        return this.nCountLastUpdateTime[1];
    }

    @Override
    public long getTotalHighWatermark() {
        if (this.nHighWatermark[2] > this.nHighWatermark[0]) {
            return this.nHighWatermark[2];
        }
        return this.nHighWatermark[0];
    }

    @Override
    public long getTotalHighWatermarkLastUpdateTime() {
        if (this.nHighWatermark[2] > this.nHighWatermark[0]) {
            return this.nHighWatermarkLastUpdateTime[2];
        }
        return this.nHighWatermarkLastUpdateTime[0];
    }

    @Override
    public long getThisPeriodHighWatermark() {
        return this.nHighWatermark[2];
    }

    @Override
    public long getThisPeriodHighWatermarkLastUpdateTime() {
        return this.nHighWatermarkLastUpdateTime[2];
    }

    @Override
    public long getLastPeriodHighWatermark() {
        return this.nHighWatermark[1];
    }

    @Override
    public long getLastPeriodHighWatermarkLastUpdateTime() {
        return this.nHighWatermarkLastUpdateTime[1];
    }

    @Override
    public long getTotalLowWatermark() {
        if (this.nLowWatermark[2] < this.nLowWatermark[0]) {
            return this.nLowWatermark[2];
        }
        return this.nLowWatermark[0];
    }

    @Override
    public long getTotalLowWatermarkLastUpdateTime() {
        if (this.nLowWatermark[2] < this.nLowWatermark[0]) {
            return this.nLowWatermarkLastUpdateTime[2];
        }
        return this.nLowWatermarkLastUpdateTime[0];
    }

    @Override
    public long getThisPeriodLowWatermark() {
        return this.nLowWatermark[2];
    }

    @Override
    public long getThisPeriodLowWatermarkLastUpdateTime() {
        return this.nLowWatermarkLastUpdateTime[2];
    }

    @Override
    public long getLastPeriodLowWatermark() {
        return this.nLowWatermark[1];
    }

    @Override
    public long getLastPeriodLowWatermarkLastUpdateTime() {
        return this.nLowWatermarkLastUpdateTime[1];
    }

    @Override
    public boolean isMandatory() {
        return this.bMandatory;
    }

    @Override
    public boolean isEnabled() {
        return this.bMandatory ? true : this.bEnabled;
    }

    public synchronized void incr() {
        this.incr(1L);
    }

    public synchronized void incr(long n) {
        this.setCount(2, this.nCount[2] + n);
        this.setWatermarks();
        this.bDirty = true;
    }

    public synchronized void decr() {
        this.decr(1L);
    }

    public synchronized void decr(long n) {
        this.setCount(2, this.nCount[2] - n);
        this.setWatermarks();
        this.bDirty = true;
    }

    @Override
    public void outputToCsv(PrintStream out) {
        out.print("\"" + this.sDescription + "\"" + ",");
        out.print(",");
        out.print(PerfOutputFormatUtil.formatNumber(this.nCount[1]) + ",");
        out.print(",,,,,,,");
        out.print(PerfOutputFormatUtil.formatNumber(this.getTotalCount()) + ",");
        out.println(",,,,,,");
    }

    @Override
    public void outputToXml(PrintStream out, boolean bOutputLastPeriod) {
        int period = 2;
        String sPeriod = "ThisPeriod";
        if (bOutputLastPeriod) {
            period = 1;
            sPeriod = "LastPeriod";
        }
        out.print("<Description>");
        out.print(this.sDescription);
        out.println("</Description>");
        out.println("<" + sPeriod + ">");
        out.print("<Count>");
        out.print(PerfOutputFormatUtil.formatNumber(this.nCount[period]));
        out.println("</Count>");
        out.println("</" + sPeriod + ">");
        out.println("<Total>");
        out.print("<Count>");
        out.print(PerfOutputFormatUtil.formatNumber(this.getTotalCount()));
        out.println("</Count>");
        out.println("</Total>");
    }

    @Override
    public synchronized void resetAll() {
        if (!this.bMandatory) {
            this.bResetingAll = true;
            for (int i = 2; i >= 0; --i) {
                this.setCount(i, 0L);
                this.setHighWatermark(i, 0L);
                this.setLowWatermark(i, 0L);
            }
            this.bDirty = false;
            this.bResetingAll = false;
        }
    }

    @Override
    public synchronized void resetPeriod() {
        this.bResetingPeriod = true;
        if (this.bDirty) {
            this.setCount(0, this.getTotalCount(), this.nCountLastUpdateTime[2]);
        }
        this.setCount(1, this.nCount[2], this.nCountLastUpdateTime[2]);
        this.setCount(2, 0L);
        if (this.nHighWatermark[2] > this.nHighWatermark[0]) {
            this.setHighWatermark(0, this.nHighWatermark[2], this.nHighWatermarkLastUpdateTime[2]);
        }
        this.setHighWatermark(1, this.nHighWatermark[2], this.nHighWatermarkLastUpdateTime[2]);
        this.setHighWatermark(2, 0L);
        if (this.nLowWatermark[2] < this.nLowWatermark[0]) {
            this.setLowWatermark(0, this.nLowWatermark[2], this.nLowWatermarkLastUpdateTime[2]);
        }
        this.setLowWatermark(1, this.nLowWatermark[2], this.nLowWatermarkLastUpdateTime[2]);
        this.setLowWatermark(2, 0L);
        this.bDirty = false;
        this.bResetingPeriod = false;
    }

    @Override
    public void setPct(PerfEntry base) {
    }

    private void setCount(int period, long n) {
        this.setCount(period, n, System.currentTimeMillis());
    }

    private void setCount(int period, long n, long timestamp) {
        if (this.mNotification != null && period == 2) {
            this.mNotification.sendThisPeriodValueChangeNotification(PerfCounterTypeEnum.CTR_COUNT, this.nCount[2], n);
            if (!this.bResetingPeriod && !this.bResetingAll) {
                this.mNotification.sendTotalValueChangeNotification(PerfCounterTypeEnum.CTR_COUNT, this.getTotalCount(), this.nCount[0] + n);
            } else if (this.bResetingAll) {
                this.mNotification.sendTotalValueChangeNotification(PerfCounterTypeEnum.CTR_COUNT, this.getTotalCount(), n);
            }
        }
        this.nCount[period] = n;
        this.nCountLastUpdateTime[period] = timestamp;
    }

    private void setHighWatermark(int period, long n) {
        this.setHighWatermark(period, n, System.currentTimeMillis());
    }

    private void setHighWatermark(int period, long n, long timestamp) {
        if (this.mNotification != null && period == 2) {
            this.mNotification.sendThisPeriodValueChangeNotification(PerfCounterTypeEnum.CTR_HIGH_WATERMARK, this.nHighWatermark[2], n);
            if (!this.bResetingPeriod && (n > this.nHighWatermark[0] || this.bResetingAll)) {
                this.mNotification.sendTotalValueChangeNotification(PerfCounterTypeEnum.CTR_HIGH_WATERMARK, this.getTotalHighWatermark(), n);
            }
        }
        this.nHighWatermark[period] = n;
        this.nHighWatermarkLastUpdateTime[period] = timestamp;
    }

    private void setLowWatermark(int period, long n) {
        this.setLowWatermark(period, n, System.currentTimeMillis());
    }

    private void setLowWatermark(int period, long n, long timestamp) {
        if (this.mNotification != null && period == 2) {
            this.mNotification.sendThisPeriodValueChangeNotification(PerfCounterTypeEnum.CTR_LOW_WATERMARK, this.nLowWatermark[2], n);
            if (!this.bResetingPeriod && (n < this.nLowWatermark[0] || this.bResetingAll)) {
                this.mNotification.sendTotalValueChangeNotification(PerfCounterTypeEnum.CTR_LOW_WATERMARK, this.getTotalLowWatermark(), n);
            }
        }
        this.nLowWatermark[period] = n;
        this.nLowWatermarkLastUpdateTime[period] = timestamp;
    }

    private void setWatermarks() {
        if (!this.bDirty) {
            this.setLowWatermark(2, this.getTotalCount());
            this.setHighWatermark(2, this.getTotalCount());
        } else if (this.getTotalCount() > this.nHighWatermark[2]) {
            this.setHighWatermark(2, this.getTotalCount());
        } else if (this.getTotalCount() < this.nLowWatermark[2]) {
            this.setLowWatermark(2, this.getTotalCount());
        }
    }

    public String toString() {
        return this.sName;
    }
}

