/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor;

import com.cognos.perfMonitor.PerfCounter;
import com.cognos.perfMonitor.PerfEntry;
import com.cognos.perfMonitor.impl.PerfOutputFormatUtil;
import java.io.PrintStream;

public class PerfMeasure
extends PerfCounter {
    private String measurement;
    protected long[] nValue = new long[3];
    protected long[] nValueSquared = new long[3];
    protected long[] nValueMin = new long[3];
    protected long[] nValueMax = new long[3];
    protected double[] nValueAvg = new double[2];
    protected double[] nValueStdDev = new double[2];
    protected double[] nValuePct = new double[2];

    protected PerfMeasure(String measurement, String name, String description, int flags) {
        super(name, description, flags);
        this.measurement = measurement;
    }

    public long getTotalValue() {
        return this.nValue[0] + this.nValue[2];
    }

    public long getTotalMinValue() {
        if (this.nCount[2] != 0L && (this.nValueMin[0] == 0L || this.nValueMin[2] < this.nValueMin[0])) {
            return this.nValueMin[2];
        }
        return this.nValueMin[0];
    }

    public long getTotalMaxValue() {
        if (this.nCount[2] != 0L && this.nValueMax[2] > this.nValueMax[0]) {
            return this.nValueMax[2];
        }
        return this.nValueMax[0];
    }

    public double getTotalAvgValue() {
        if (this.getTotalCount() != 0L) {
            return (double)this.getTotalValue() / (double)this.getTotalCount();
        }
        return 0.0;
    }

    public double getTotalStdValue() {
        if (this.getTotalCount() != 0L) {
            double totAvg = this.getTotalAvgValue();
            return Math.sqrt(((double)this.nValueSquared[0] + (double)this.nValueSquared[2]) / (double)this.getTotalCount() - totAvg * totAvg);
        }
        return 0.0;
    }

    @Override
    public synchronized void incr() {
        this.incr(1L);
    }

    @Override
    public synchronized void incr(long n) {
        this.nCount[2] = this.nCount[2] + 1L;
        this.nValue[2] = this.nValue[2] + n;
        this.nValueSquared[2] = this.nValueSquared[2] + n * n;
        this.setMinValue(2, n);
        this.setMaxValue(2, n);
    }

    @Override
    public synchronized void decr() {
        this.decr(1L);
    }

    @Override
    public synchronized void decr(long n) {
        this.nCount[2] = this.nCount[2] + 1L;
        this.nValue[2] = this.nValue[2] - n;
        this.nValueSquared[2] = this.nValueSquared[2] + n * n;
        this.setMinValue(2, n);
        this.setMaxValue(2, n);
    }

    @Override
    public synchronized void outputToCsv(PrintStream out) {
        out.print("\"" + this.sDescription + "\"" + ",");
        out.print(",");
        out.print(PerfOutputFormatUtil.formatNumber(this.nCount[1]) + ",");
        out.print(PerfOutputFormatUtil.formatNumber(this.nValue[1]) + ",");
        out.print(PerfOutputFormatUtil.formatNumber(this.nValueMin[1]) + ",");
        out.print(PerfOutputFormatUtil.formatNumber(this.nValueMax[1]) + ",");
        out.print(PerfOutputFormatUtil.formatNumber_3Decimals(this.nValueAvg[1]) + ",");
        out.print(PerfOutputFormatUtil.formatNumber_3Decimals(this.nValueStdDev[1]) + ",");
        if (this.nValuePct[1] != 0.0) {
            out.print(PerfOutputFormatUtil.formatNumber_3Decimals(this.nValuePct[1]) + ",");
        } else {
            out.print(",");
        }
        out.print(",");
        out.print(PerfOutputFormatUtil.formatNumber(this.getTotalCount()) + ",");
        out.print(PerfOutputFormatUtil.formatNumber(this.getTotalValue()) + ",");
        out.print(PerfOutputFormatUtil.formatNumber(this.getTotalMinValue()) + ",");
        out.print(PerfOutputFormatUtil.formatNumber(this.getTotalMaxValue()) + ",");
        out.print(PerfOutputFormatUtil.formatNumber_3Decimals(this.getTotalAvgValue()) + ",");
        out.print(PerfOutputFormatUtil.formatNumber_3Decimals(this.getTotalStdValue()) + ",");
        if (this.nValuePct[0] != 0.0) {
            out.println(PerfOutputFormatUtil.formatNumber_3Decimals(this.nValuePct[0]));
        } else {
            out.println("");
        }
    }

    @Override
    public synchronized void outputToXml(PrintStream out, boolean bOutputLastPeriod) {
        int period = 2;
        String sPeriod = "ThisPeriod";
        if (bOutputLastPeriod) {
            period = 1;
            sPeriod = "LastPeriod";
        }
        out.print("<Description>");
        out.print(this.sDescription);
        out.println("</Description>");
        out.println("<" + sPeriod + ">");
        out.print("<Count>");
        out.print(PerfOutputFormatUtil.formatNumber(this.nCount[period]));
        out.println("</Count>");
        out.print("<" + this.measurement + ">");
        out.print(PerfOutputFormatUtil.formatNumber(this.nValue[period]));
        out.println("</" + this.measurement + ">");
        out.print("<" + this.measurement + "Min>");
        out.print(PerfOutputFormatUtil.formatNumber(this.nValueMin[period]));
        out.println("</" + this.measurement + "Min>");
        out.print("<" + this.measurement + "Max>");
        out.print(PerfOutputFormatUtil.formatNumber(this.nValueMax[period]));
        out.println("</" + this.measurement + "Max>");
        if (bOutputLastPeriod) {
            out.print("<" + this.measurement + "Avg>");
            out.print(PerfOutputFormatUtil.formatNumber_3Decimals(this.nValueAvg[1]));
            out.println("</" + this.measurement + "Avg>");
            out.print("<" + this.measurement + "Std>");
            out.print(PerfOutputFormatUtil.formatNumber_3Decimals(this.nValueStdDev[1]));
            out.println("</" + this.measurement + "Std>");
            if (this.nValuePct[1] != 0.0) {
                out.print("<" + this.measurement + "Pct>");
                out.print(PerfOutputFormatUtil.formatNumber_3Decimals(this.nValuePct[1]));
                out.println("</" + this.measurement + "Pct>");
            }
        }
        out.println("</" + sPeriod + ">");
        out.println("<Total>");
        out.print("<Count>");
        out.print(PerfOutputFormatUtil.formatNumber(this.getTotalCount()));
        out.println("</Count>");
        out.print("<" + this.measurement + ">");
        out.print(PerfOutputFormatUtil.formatNumber(this.getTotalValue()));
        out.println("</" + this.measurement + ">");
        out.print("<" + this.measurement + "Min>");
        out.print(PerfOutputFormatUtil.formatNumber(this.getTotalMinValue()));
        out.println("</" + this.measurement + "Min>");
        out.print("<" + this.measurement + "Max>");
        out.print(PerfOutputFormatUtil.formatNumber(this.getTotalMaxValue()));
        out.println("</" + this.measurement + "Max>");
        out.print("<" + this.measurement + "Avg>");
        out.print(PerfOutputFormatUtil.formatNumber_3Decimals(this.getTotalAvgValue()));
        out.println("</" + this.measurement + "Avg>");
        out.print("<" + this.measurement + "Std>");
        out.print(PerfOutputFormatUtil.formatNumber_3Decimals(this.getTotalStdValue()));
        out.println("</" + this.measurement + "Std>");
        if (this.nValuePct[0] != 0.0) {
            out.print("<" + this.measurement + "Pct>");
            out.print(PerfOutputFormatUtil.formatNumber_3Decimals(this.nValuePct[0]));
            out.println("</" + this.measurement + "Pct>");
        }
        out.println("</Total>");
    }

    @Override
    public synchronized void resetAll() {
        if (!this.isMandatory()) {
            this.nCount[0] = 0L;
            this.nCount[1] = 0L;
            this.nCount[2] = 0L;
            this.nValue[0] = 0L;
            this.nValue[1] = 0L;
            this.nValue[2] = 0L;
            this.nValueSquared[0] = 0L;
            this.nValueSquared[1] = 0L;
            this.nValueSquared[2] = 0L;
            this.nValueMin[0] = 0L;
            this.nValueMin[1] = 0L;
            this.nValueMin[2] = 0L;
            this.nValueMax[0] = 0L;
            this.nValueMax[1] = 0L;
            this.nValueMax[2] = 0L;
            this.nValueAvg[0] = 0.0;
            this.nValueAvg[1] = 0.0;
            this.nValueStdDev[0] = 0.0;
            this.nValueStdDev[1] = 0.0;
            this.nValuePct[0] = 0.0;
            this.nValuePct[1] = 0.0;
        }
    }

    @Override
    public synchronized void resetPeriod() {
        this.nCount[0] = this.getTotalCount();
        this.nCount[1] = this.nCount[2];
        this.nCount[2] = 0L;
        this.nValue[0] = this.getTotalValue();
        this.nValue[1] = this.nValue[2];
        this.nValue[2] = 0L;
        this.nValueSquared[1] = this.nValueSquared[2];
        this.nValueSquared[2] = 0L;
        this.nValueSquared[0] = this.nValueSquared[0] + this.nValueSquared[1];
        this.nValueMin[1] = this.nValueMin[2];
        this.nValueMin[2] = 0L;
        if (this.nCount[1] != 0L) {
            this.setMinValue(0, this.nValueMin[1]);
        }
        this.nValueMax[1] = this.nValueMax[2];
        this.nValueMax[2] = 0L;
        if (this.nCount[1] != 0L) {
            this.setMaxValue(0, this.nValueMax[1]);
        }
        this.computeStdDevValue();
    }

    @Override
    public synchronized void setPct(PerfEntry base) {
        if (base instanceof PerfMeasure) {
            this.nValuePct[0] = this.getTotalCount() != 0L ? (double)this.getTotalValue() * 100.0 / (double)((PerfMeasure)base).getTotalValue() : 0.0;
            this.nValuePct[1] = this.nCount[1] != 0L ? (double)this.nValue[1] * 100.0 / (double)((PerfMeasure)base).nValue[1] : 0.0;
        }
    }

    protected void setMinValue(int index, long value) {
        if (this.nValueMin[index] == 0L || value < this.nValueMin[index]) {
            this.nValueMin[index] = value;
        }
    }

    protected void setMaxValue(int index, long value) {
        if (value > this.nValueMax[index]) {
            this.nValueMax[index] = value;
        }
    }

    protected void computeAvgValue() {
        this.nValueAvg[0] = this.nCount[0] != 0L ? (double)this.nValue[0] / (double)this.nCount[0] : 0.0;
        this.nValueAvg[1] = this.nCount[1] != 0L ? (double)this.nValue[1] / (double)this.nCount[1] : 0.0;
    }

    protected void computeStdDevValue() {
        this.computeAvgValue();
        this.nValueStdDev[0] = this.nCount[0] != 0L ? Math.sqrt((double)this.nValueSquared[0] / (double)this.nCount[0] - this.nValueAvg[0] * this.nValueAvg[0]) : 0.0;
        this.nValueStdDev[1] = this.nCount[1] != 0L ? Math.sqrt((double)this.nValueSquared[1] / (double)this.nCount[1] - this.nValueAvg[1] * this.nValueAvg[1]) : 0.0;
    }
}

