/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor;

import com.cognos.perfMonitor.PerfCategory;
import com.cognos.perfMonitor.PerfCounter;
import com.cognos.perfMonitor.PerfEntry;
import com.cognos.perfMonitor.PerfEntryTypeEnum;
import com.cognos.perfMonitor.PerfMeasure;
import com.cognos.perfMonitor.PerfTimer;
import com.cognos.perfMonitor.impl.PerfException;
import com.cognos.perfMonitor.impl.PerfOutput;
import com.cognos.perfMonitor.impl.PerfOutputFactory;
import com.cognos.perfMonitor.impl.PerfOutputFormatEnum;
import com.cognos.perfMonitor.impl.PerfTimerImpl;
import com.cognos.perfMonitor.impl.PerfTimerThreadLocalImpl;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PerfMonitor {
    private static ConcurrentHashMap<String, PerfEntry> mEntries = new ConcurrentHashMap();
    private static volatile ConcurrentHashMap<String, PerfEntry> mEnabledEntries = new ConcurrentHashMap();
    private static String[] mCategories = new String[0];
    private static PerfMeasure mBaseEntry = null;
    private static PerfOutputThread mOutputThread = null;
    private static PerfOutput mOutput = null;
    protected static Class<? extends PerfTimerImpl> timerImpl = null;
    protected static Class<? extends PerfTimerThreadLocalImpl> threadLocalTimerImpl = null;

    public static PerfCategory getCategory(String sName, String sDescription, int flags) {
        PerfCategory category = (PerfCategory)PerfMonitor.getEntry(sName);
        if (category == null) {
            category = PerfMonitor.createCategory(sName, sDescription, flags);
        }
        return category;
    }

    public static PerfTimer getThreadLocalTimer(String sEntry, int flags) {
        return PerfMonitor.getThreadLocalTimer(sEntry, "", flags);
    }

    public static PerfTimer getThreadLocalTimer(String sEntry, String sDescription, int flags) {
        PerfEntry entry = PerfMonitor.getEntry(sEntry);
        if (entry == null) {
            entry = PerfMonitor.createTimerEntry(sEntry, sDescription, flags);
        }
        PerfMeasure measure = (PerfMeasure)entry;
        PerfTimer newTimer = PerfMonitor.newPerfTimerThreadLocalImpl(measure);
        return newTimer;
    }

    private static PerfTimer newPerfTimerThreadLocalImpl(PerfMeasure measure) {
        if (threadLocalTimerImpl != null) {
            return PerfMonitor.newInstance(threadLocalTimerImpl, measure);
        }
        PerfTimerThreadLocalImpl timer = new PerfTimerThreadLocalImpl(measure);
        return timer;
    }

    public static PerfTimer getTimer(String sEntry) {
        return PerfMonitor.getTimer(sEntry, "");
    }

    public static PerfTimer getTimer(String sEntry, String sDescription) {
        return PerfMonitor.getTimer(sEntry, sDescription, 1);
    }

    public static PerfTimer getTimer(String sEntry, String sDescription, int flags) {
        PerfEntry entry = PerfMonitor.getEntry(sEntry);
        if (entry == null) {
            entry = PerfMonitor.createTimerEntry(sEntry, sDescription, flags);
        }
        PerfTimer newTimer = PerfMonitor.newPerfTimerImpl((PerfMeasure)entry);
        return newTimer;
    }

    private static PerfTimer newPerfTimerImpl(PerfMeasure entry) {
        PerfTimer timer = timerImpl == null ? new PerfTimerImpl(entry) : PerfMonitor.newInstance(timerImpl, entry);
        return timer;
    }

    private static PerfTimer newInstance(Class<?> clazz, PerfMeasure entry) {
        try {
            Class[] args = new Class[]{PerfMeasure.class};
            Constructor<?> constructor = clazz.getConstructor(args);
            return (PerfTimer)constructor.newInstance(entry);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized PerfCategory createCategory(String sEntry, String sDescription, int flags) {
        PerfEntry entry = PerfMonitor.getEntry(sEntry);
        if (entry == null) {
            boolean bEnabled = true;
            if (!PerfMonitor.isCategoryEnabled(sEntry)) {
                bEnabled = false;
            }
            entry = PerfMonitor.newEntry(PerfEntryTypeEnum.CATEGORY, flags, bEnabled, sEntry, sDescription);
            PerfMonitor.addEntry(sEntry, entry);
        }
        return (PerfCategory)entry;
    }

    private static synchronized PerfEntry createTimerEntry(String sEntry, String sDescription, int flags) {
        PerfEntry entry = PerfMonitor.getEntry(sEntry);
        if (entry == null) {
            boolean bEnabled = true;
            if (!PerfMonitor.isCategoryEnabled(sEntry)) {
                bEnabled = false;
            }
            entry = PerfMonitor.newEntry(PerfEntryTypeEnum.TIME, flags, bEnabled, sEntry, sDescription);
            PerfMonitor.addEntry(sEntry, entry);
        }
        return entry;
    }

    public static PerfCounter getCounter(String sEntry) {
        return PerfMonitor.getCounter(sEntry, "", 1);
    }

    public static PerfCounter getCounter(String sEntry, String sDescription, int flags) {
        PerfEntry entry = PerfMonitor.getEntry(sEntry);
        if (entry == null) {
            entry = PerfMonitor.createCounterEntry(sEntry, sDescription, flags);
        }
        return (PerfCounter)entry;
    }

    private static synchronized PerfEntry createCounterEntry(String sEntry, String sDescription, int flags) {
        PerfEntry entry = PerfMonitor.getEntry(sEntry);
        if (entry == null) {
            boolean bEnabled = true;
            if (!PerfMonitor.isCategoryEnabled(sEntry)) {
                bEnabled = false;
            }
            entry = PerfMonitor.newEntry(PerfEntryTypeEnum.COUNT, flags, bEnabled, sEntry, sDescription);
            PerfMonitor.addEntry(sEntry, entry);
        }
        return entry;
    }

    public static PerfMeasure getMeasure(String sEntry, int flags) {
        return PerfMonitor.getMeasure(sEntry, "", flags);
    }

    public static PerfMeasure getMeasure(String sEntry, String sDescription, int flags) {
        PerfEntry entry = PerfMonitor.getEntry(sEntry);
        if (entry == null) {
            entry = PerfMonitor.createMeasureEntry(sEntry, sDescription, flags);
        }
        return (PerfMeasure)entry;
    }

    private static synchronized PerfEntry createMeasureEntry(String sEntry, String sDescription, int flags) {
        PerfEntry entry = PerfMonitor.getEntry(sEntry);
        if (entry == null) {
            boolean bEnabled = true;
            if (!PerfMonitor.isCategoryEnabled(sEntry)) {
                bEnabled = false;
            }
            entry = PerfMonitor.newEntry(PerfEntryTypeEnum.SIZE, flags, bEnabled, sEntry, sDescription);
            PerfMonitor.addEntry(sEntry, entry);
        }
        return entry;
    }

    public static PerfEntry newEntry(PerfEntryTypeEnum type, int flags, boolean bEnabled, String sName, String sDescription) {
        PerfEntry entry;
        if (type == PerfEntryTypeEnum.CATEGORY) {
            entry = new PerfCategory(sName, sDescription, flags);
        } else if (type == PerfEntryTypeEnum.COUNT) {
            entry = new PerfCounter(sName, sDescription, flags);
        } else if (type == PerfEntryTypeEnum.TIME || type == PerfEntryTypeEnum.SIZE) {
            entry = new PerfMeasure(type.toString(), sName, sDescription, flags);
        } else {
            throw new RuntimeException("Unknown counter type: " + type);
        }
        entry.setEnabled(bEnabled);
        return entry;
    }

    public static PerfEntry getEntry(String sEntry) {
        String lowerString = sEntry;
        return mEntries.get(lowerString);
    }

    public static void addEntry(String sEntry, PerfEntry entry) {
        mEntries.put(sEntry, entry);
        if (PerfMonitor.isCategoryEnabled(sEntry)) {
            mEnabledEntries.put(sEntry, entry);
        }
    }

    public static void removeEntry(String sEntry) {
        mEntries.remove(sEntry);
        mEnabledEntries.remove(sEntry);
    }

    public static int getNumber() {
        return mEntries.size();
    }

    public static ArrayList<String> getEnabledEntryKeys() {
        ArrayList<String> entryNames = new ArrayList<String>();
        Iterator e = ((ConcurrentHashMap.KeySetView)mEnabledEntries.keySet()).iterator();
        while (e.hasNext()) {
            entryNames.add((String)e.next());
        }
        return entryNames;
    }

    public static void enableCategory(String category) {
        PerfMonitor.enableCategory(new String[]{category}, true);
    }

    public static synchronized void enableCategory(String[] categories, boolean bResetPeriod) {
        mCategories = new String[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            PerfMonitor.mCategories[i] = categories[i];
        }
        ConcurrentHashMap<String, PerfEntry> newEnabledEntries = new ConcurrentHashMap<String, PerfEntry>();
        Iterator iter = ((ConcurrentHashMap.KeySetView)mEntries.keySet()).iterator();
        while (iter.hasNext()) {
            String sEntry = (String)iter.next();
            PerfEntry entry = mEntries.get(sEntry);
            boolean bEnabled = PerfMonitor.isCategoryEnabled(sEntry);
            if (bEnabled) {
                entry.enable();
                newEnabledEntries.put(sEntry, entry);
                continue;
            }
            if (entry.isPermanent()) continue;
            iter.remove();
            entry.disable();
        }
        if (bResetPeriod) {
            PerfMonitor.resetPeriod();
        }
        mEnabledEntries = newEnabledEntries;
    }

    private static synchronized boolean isCategoryEnabled(String sCategory) {
        boolean bEnabled = false;
        for (int i = 0; i < mCategories.length; ++i) {
            if (!sCategory.startsWith(mCategories[i])) continue;
            bEnabled = true;
        }
        return bEnabled;
    }

    public static PerfMeasure getBaseEntry() {
        return mBaseEntry;
    }

    public static void setBaseEntry(PerfMeasure measure) {
        mBaseEntry = measure;
    }

    public static void resetAll() {
        for (Map.Entry<String, PerfEntry> me : mEntries.entrySet()) {
            PerfEntry entry = me.getValue();
            if (entry.isMandatory()) continue;
            entry.resetAll();
        }
    }

    public static void resetPeriod() {
        for (Map.Entry<String, PerfEntry> me : mEnabledEntries.entrySet()) {
            me.getValue().resetPeriod();
        }
    }

    public static synchronized boolean startRecording(int nInterval, String sFormat, String sOutputLocation, String sFilter) throws PerfException {
        if (mOutputThread == null) {
            PerfOutputFormatEnum format = PerfMonitor.getOutputFormat(sFormat);
            if (format == null) {
                throw new PerfException("Illegal output format \"" + sFormat + "\" specified");
            }
            mOutput = PerfOutputFactory.newOutput(format, sOutputLocation);
            mOutputThread = new PerfOutputThread(nInterval, sFilter);
            mOutputThread.start();
            if (nInterval <= 0) {
                PerfMonitor.stopRecording();
            }
            return true;
        }
        return false;
    }

    public static synchronized boolean isRecording() {
        return mOutputThread != null;
    }

    public static synchronized boolean stopRecording() {
        if (mOutputThread != null) {
            mOutputThread.stopOutputing();
            mOutputThread = null;
            return true;
        }
        return false;
    }

    public static void outputEntries(OutputStream o, String sFilter, boolean bResetPeriod) {
        if (bResetPeriod) {
            PerfMonitor.resetPeriod();
        }
        if (o != null) {
            mOutput = PerfOutputFactory.newOutput(PerfOutputFormatEnum.OUTPUT_FORMAT_XML, o);
        }
        for (String sEntry : mEnabledEntries.keySet()) {
            PerfEntry entry;
            if (!sEntry.startsWith(sFilter) || (entry = PerfMonitor.getEntry(sEntry)) == null || !entry.isEnabled() || entry instanceof PerfCategory) continue;
            PerfMeasure baseEntry = PerfMonitor.getBaseEntry();
            if (baseEntry != null && baseEntry.getClass().isInstance(entry)) {
                entry.setPct(baseEntry);
            }
            mOutput.outputToSystem(sEntry, entry, bResetPeriod);
        }
    }

    private static PerfOutputFormatEnum getOutputFormat(String sConst) {
        if (PerfOutputFormatEnum.OUTPUT_FORMAT_XML.toString().equalsIgnoreCase(sConst)) {
            return PerfOutputFormatEnum.OUTPUT_FORMAT_XML;
        }
        if (PerfOutputFormatEnum.OUTPUT_FORMAT_CSV.toString().equalsIgnoreCase(sConst)) {
            return PerfOutputFormatEnum.OUTPUT_FORMAT_CSV;
        }
        return null;
    }

    protected static void dump(PrintStream out) {
        for (Map.Entry<String, PerfEntry> me : mEntries.entrySet()) {
            PerfEntry entry = me.getValue();
            out.println("entry=" + entry + " => " + System.identityHashCode(entry));
        }
    }

    private static class PerfOutputThread
    extends Thread {
        private volatile boolean bRun = true;
        private int nInterval;
        private String sFilter;

        public PerfOutputThread(int interval, String filter) {
            this.nInterval = interval;
            this.sFilter = filter;
            if (this.nInterval <= 0) {
                this.bRun = false;
            }
        }

        @Override
        public void run() {
            mOutput.initialize();
            do {
                try {
                    mOutput.beforeOutput();
                    PerfMonitor.outputEntries(null, this.sFilter, true);
                    mOutput.afterOutput();
                    if (this.nInterval <= 0) continue;
                    PerfOutputThread.sleep(this.nInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.bRun);
            mOutput.close();
        }

        public void stopOutputing() {
            this.bRun = false;
        }
    }
}

