/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor.impl;

import com.cognos.perfMonitor.PerfEntry;
import com.cognos.perfMonitor.impl.PerfException;
import com.cognos.perfMonitor.impl.PerfOutput;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.TimeZone;

public class PerfOutputCsv
implements PerfOutput {
    private PrintStream out;
    private String sFileName;
    private String timestampString;

    public PerfOutputCsv(OutputStream oStream) {
        this.out = new PrintStream(oStream);
    }

    public PerfOutputCsv(String sOutputLocation) throws PerfException {
        this.sFileName = sOutputLocation + File.separator + "perfOutput.csv";
        try {
            this.out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.sFileName, true)));
        }
        catch (FileNotFoundException e) {
            throw new PerfException("Unable to open file " + this.sFileName);
        }
    }

    @Override
    public void initialize() {
        File file;
        boolean bOutputFirstRow = true;
        if (this.sFileName != null && (file = new File(this.sFileName)).length() > 0L) {
            bOutputFirstRow = false;
        }
        if (bOutputFirstRow) {
            this.out.print("Time,");
            this.out.print("Name,");
            this.out.print("Description,");
            this.out.print("LASTPERIOD,");
            this.out.print("CountLASTPERIOD,");
            this.out.print("ValueLASTPERIOD,");
            this.out.print("minLASTPERIOD,");
            this.out.print("maxLASTPERIOD,");
            this.out.print("avgLASTPERIOD,");
            this.out.print("stdLASTPERIOD,");
            this.out.print("pctLASTPERIOD,");
            this.out.print("TOTAL,");
            this.out.print("CountTOTAL,");
            this.out.print("ValueTOTAL,");
            this.out.print("minTOTAL,");
            this.out.print("maxTOTAL,");
            this.out.print("avgTOTAL,");
            this.out.print("stdTOTAL,");
            this.out.println("pctTOTAL");
        }
    }

    @Override
    public void beforeOutput() {
        this.timestampString = Calendar.getInstance(TimeZone.getTimeZone("GMT-0")).getTime().toString();
        this.out.println();
    }

    @Override
    public void outputToSystem(String sEntry, PerfEntry entry, boolean bLastPeriod) {
        this.out.print(this.timestampString);
        this.out.print(",");
        this.out.print("\"" + (sEntry.length() <= 250 ? sEntry : sEntry.substring(0, 250)) + "\",");
        entry.outputToCsv(this.out);
    }

    @Override
    public void afterOutput() {
    }

    @Override
    public void close() {
        this.out.close();
    }
}

