/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor.impl;

import com.cognos.perfMonitor.impl.PerfException;
import com.cognos.perfMonitor.impl.PerfOutput;
import com.cognos.perfMonitor.impl.PerfOutputCsv;
import com.cognos.perfMonitor.impl.PerfOutputFormatEnum;
import com.cognos.perfMonitor.impl.PerfOutputXml;
import java.io.OutputStream;

public class PerfOutputFactory {
    public static PerfOutput newOutput(PerfOutputFormatEnum format, String sOutputLocation) throws PerfException {
        if (format == PerfOutputFormatEnum.OUTPUT_FORMAT_XML) {
            return new PerfOutputXml(sOutputLocation);
        }
        if (format == PerfOutputFormatEnum.OUTPUT_FORMAT_CSV) {
            return new PerfOutputCsv(sOutputLocation);
        }
        throw new PerfException("Illegal output format \"" + format.toString() + "\" specified.");
    }

    public static PerfOutput newOutput(PerfOutputFormatEnum format, OutputStream oStream) {
        if (format == PerfOutputFormatEnum.OUTPUT_FORMAT_XML) {
            return new PerfOutputXml(oStream);
        }
        return new PerfOutputCsv(oStream);
    }
}

