/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor.impl;

import com.cognos.cmutils.xml.XMLUtils;
import com.cognos.perfMonitor.PerfEntry;
import com.cognos.perfMonitor.impl.PerfException;
import com.cognos.perfMonitor.impl.PerfOutput;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.TimeZone;

public class PerfOutputXml
implements PerfOutput {
    private PrintStream out;

    public PerfOutputXml(OutputStream oStream) {
        this.out = new PrintStream(oStream);
    }

    public PerfOutputXml(String sOutputLocation) throws PerfException {
        long time = Calendar.getInstance(TimeZone.getTimeZone("GMT-0")).getTime().getTime();
        String sFileName = sOutputLocation + File.separator + "perfOutput_" + time + ".xml";
        try {
            this.out = new PrintStream(new BufferedOutputStream(new FileOutputStream(sFileName)));
        }
        catch (FileNotFoundException e) {
            throw new PerfException("Unable to open file " + sFileName);
        }
    }

    @Override
    public void initialize() {
        this.out.println("<PERF_OUTPUT>");
    }

    @Override
    public void beforeOutput() {
        this.out.print("<Output time='");
        this.out.print(Calendar.getInstance(TimeZone.getTimeZone("GMT-0")).getTime().toString());
        this.out.println("'>");
    }

    @Override
    public void outputToSystem(String sEntry, PerfEntry entry, boolean bLastPeriod) {
        this.out.print("<entry name='");
        this.out.print(XMLUtils.encode(sEntry));
        this.out.println("'>");
        entry.outputToXml(this.out, bLastPeriod);
        this.out.println("</entry>");
    }

    @Override
    public void afterOutput() {
        this.out.println("</Output>");
    }

    @Override
    public void close() {
        this.out.flush();
        this.out.println("</PERF_OUTPUT>");
        this.out.close();
    }
}

